/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.spmm.manager;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.learnlib.AccessSequenceTransformer;
import de.learnlib.algorithm.procedural.SymbolWrapper;
import de.learnlib.algorithm.procedural.spmm.ATManager;
import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.Pair;
import net.automatalib.word.Word;

public class DefaultATManager<I, O>
implements ATManager<I, O> {
    private final Map<I, Word<I>> accessSequences;
    private final Map<I, Word<I>> terminatingSequences;
    private final ProceduralInputAlphabet<I> inputAlphabet;
    private final O errorOutput;

    public DefaultATManager(ProceduralInputAlphabet<I> inputAlphabet, O errorOutput) {
        this.inputAlphabet = inputAlphabet;
        this.errorOutput = errorOutput;
        this.accessSequences = Maps.newHashMapWithExpectedSize(inputAlphabet.getNumCalls());
        this.terminatingSequences = Maps.newHashMapWithExpectedSize(inputAlphabet.getNumCalls());
    }

    @Override
    public Word<I> getAccessSequence(I procedure) {
        assert (this.accessSequences.containsKey(procedure));
        return this.accessSequences.get(procedure);
    }

    @Override
    public Word<I> getTerminatingSequence(I procedure) {
        assert (this.terminatingSequences.containsKey(procedure));
        return this.terminatingSequences.get(procedure);
    }

    @Override
    public Pair<Set<I>, Set<I>> scanCounterexample(DefaultQuery<I, Word<O>> counterexample) {
        HashSet newCalls = Sets.newHashSetWithExpectedSize(this.inputAlphabet.getNumCalls() - this.accessSequences.size());
        HashSet newTerms = Sets.newHashSetWithExpectedSize(this.inputAlphabet.getNumCalls() - this.terminatingSequences.size());
        Word input = counterexample.getInput();
        Word<O> output = counterexample.getOutput();
        for (int i = 0; i < input.size(); ++i) {
            int returnIdx;
            Object sym = input.getSymbol(i);
            if (!this.inputAlphabet.isCallSymbol(sym)) continue;
            if (!this.accessSequences.containsKey(sym)) {
                this.accessSequences.put(sym, input.prefix(i + 1));
                newCalls.add(sym);
            }
            if ((returnIdx = this.inputAlphabet.findReturnIndex(input, i + 1)) <= 0 || this.terminatingSequences.containsKey(sym) || Objects.equals(this.errorOutput, output.getSymbol(returnIdx))) continue;
            this.terminatingSequences.put(sym, input.subWord(i + 1, returnIdx));
            newTerms.add(sym);
        }
        return Pair.of(newCalls, newTerms);
    }

    @Override
    public Set<I> scanProcedures(Map<I, ? extends MealyMachine<?, SymbolWrapper<I>, ?, O>> procedures, Map<I, ? extends AccessSequenceTransformer<SymbolWrapper<I>>> providers, Collection<SymbolWrapper<I>> inputs) {
        return Collections.emptySet();
    }
}

