/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.rpni;

import de.learnlib.algorithm.PassiveLearningAlgorithm;
import de.learnlib.algorithm.rpni.AbstractBlueFringeRPNI;
import de.learnlib.algorithm.rpni.EDSMUtil;
import de.learnlib.datastructure.pta.BlueFringePTA;
import de.learnlib.datastructure.pta.BlueFringePTAState;
import de.learnlib.datastructure.pta.RedBlueMerge;
import de.learnlib.datastructure.pta.wrapper.DFAWrapper;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.common.smartcollection.IntSeq;
import net.automatalib.common.util.Pair;
import net.automatalib.word.Word;

public class BlueFringeEDSMDFA<I>
extends AbstractBlueFringeRPNI<I, Boolean, Boolean, Void, DFA<?, I>>
implements PassiveLearningAlgorithm.PassiveDFALearner<I> {
    private final List<IntSeq> positive = new ArrayList<IntSeq>();
    private final List<IntSeq> negative = new ArrayList<IntSeq>();

    public BlueFringeEDSMDFA(Alphabet<I> alphabet) {
        super(alphabet);
    }

    @Override
    public void addSamples(Collection<? extends DefaultQuery<I, Boolean>> samples) {
        for (DefaultQuery<I, Boolean> query : samples) {
            Word input = query.getInput();
            if (query.getOutput().booleanValue()) {
                this.positive.add(input.asIntSeq(this.alphabet));
                continue;
            }
            this.negative.add(input.asIntSeq(this.alphabet));
        }
    }

    @Override
    protected BlueFringePTA<Boolean, Void> fetchPTA() {
        BlueFringePTA<Boolean, Void> pta = new BlueFringePTA<Boolean, Void>(this.alphabet.size());
        for (IntSeq pos : this.positive) {
            pta.addSample(pos, true);
        }
        for (IntSeq neg : this.negative) {
            pta.addSample(neg, false);
        }
        return pta;
    }

    @Override
    protected Stream<RedBlueMerge<BlueFringePTAState<Boolean, Void>, Boolean, Void>> selectMerges(Stream<RedBlueMerge<BlueFringePTAState<Boolean, Void>, Boolean, Void>> merges) {
        return merges.map(merge -> Pair.of(merge, EDSMUtil.score(merge.toMergedAutomaton(), this.positive, this.negative))).sorted(Collections.reverseOrder(Comparator.comparingLong(Pair::getSecond))).map(Pair::getFirst);
    }

    @Override
    protected DFA<?, I> ptaToModel(BlueFringePTA<Boolean, Void> pta) {
        return new DFAWrapper(this.alphabet, pta);
    }
}

