/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.rpni;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.common.smartcollection.IntSeq;

final class EDSMUtil {
    private EDSMUtil() {
    }

    static <S> long score(UniversalDeterministicAutomaton<S, Integer, ?, Boolean, ?> merge, List<IntSeq> positiveSamples, List<IntSeq> negativeSamples) {
        int index;
        Collection states = merge.getStates();
        int numStates = states.size();
        HashMap stateIDs = Maps.newHashMapWithExpectedSize(numStates);
        int counter = 0;
        for (Object s2 : states) {
            stateIDs.put(s2, counter++);
        }
        int[] tp = new int[numStates];
        int[] tn = new int[numStates];
        for (IntSeq w : positiveSamples) {
            int n = index = ((Integer)stateIDs.get(merge.getState(w))).intValue();
            tp[n] = tp[n] + 1;
        }
        for (IntSeq w : negativeSamples) {
            int n = index = ((Integer)stateIDs.get(merge.getState(w))).intValue();
            tn[n] = tn[n] + 1;
        }
        int score = 0;
        for (int i = 0; i < numStates; ++i) {
            if (tn[i] > 0) {
                score += tn[i] - 1;
                continue;
            }
            if (tp[i] <= 0) continue;
            score += tp[i] - 1;
        }
        return score;
    }
}

