/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.ttt.vpa;

import com.google.common.collect.Iterables;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.algorithm.observationpack.vpa.OPLearnerVPA;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.AbstractHypTrans;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.BlockList;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.ContextPair;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.DTNode;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.HypLoc;
import de.learnlib.algorithm.observationpack.vpa.hypothesis.TransList;
import de.learnlib.algorithm.ttt.vpa.ExtractRecord;
import de.learnlib.algorithm.ttt.vpa.GlobalSplitter;
import de.learnlib.algorithm.ttt.vpa.NonDetState;
import de.learnlib.algorithm.ttt.vpa.NondetStackContents;
import de.learnlib.algorithm.ttt.vpa.OutputInconsistency;
import de.learnlib.algorithm.ttt.vpa.Splitter;
import de.learnlib.datastructure.discriminationtree.SplitData;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.datastructure.discriminationtree.model.AbstractTemporaryIntrusiveDTNode;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.vpa.StackContents;
import net.automatalib.automaton.vpa.State;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TTTLearnerVPA<I>
extends OPLearnerVPA<I> {
    private final BlockList<I> blockList = new BlockList();

    public TTTLearnerVPA(VPAlphabet<I> alphabet, MembershipOracle.DFAMembershipOracle<I> oracle, AcexAnalyzer analyzer) {
        super(alphabet, oracle, analyzer);
    }

    @Override
    protected State<HypLoc<I>> getDefinitiveSuccessor(State<HypLoc<I>> baseState, Word<I> suffix) {
        NonDetState<Object> curr = NonDetState.fromDet(baseState);
        int lastDet = 0;
        NonDetState<Object> lastDetState = curr;
        int i = 0;
        for (I sym : suffix) {
            HashSet<HypLoc<I>> succs;
            if (this.alphabet.isCallSymbol(sym)) {
                HashSet<Integer> stackSyms = new HashSet<Integer>();
                for (HypLoc<I> loc : curr.getLocations()) {
                    int stackSym = this.hypothesis.encodeStackSym(loc, sym);
                    stackSyms.add(stackSym);
                }
                NondetStackContents nsc = NondetStackContents.push(stackSyms, curr.getStack());
                curr = new NonDetState<Object>(Collections.singleton(this.hypothesis.getInitialLocation()), nsc);
            } else if (this.alphabet.isReturnSymbol(sym)) {
                succs = new HashSet<HypLoc<I>>();
                for (HypLoc<I> loc : curr.getLocations()) {
                    for (int stackSym : curr.getStack().peek()) {
                        AbstractHypTrans<I> trans = this.hypothesis.getReturnTransition(loc, sym, stackSym);
                        if (trans.isTree()) {
                            succs.add(trans.getTreeTarget());
                            continue;
                        }
                        Iterables.addAll(succs, trans.getNonTreeTarget().subtreeLocations());
                    }
                }
                curr = new NonDetState(succs, curr.getStack().pop());
            } else {
                succs = new HashSet();
                for (HypLoc<I> loc : curr.getLocations()) {
                    AbstractHypTrans<I> trans = this.hypothesis.getInternalTransition(loc, sym);
                    if (trans.isTree()) {
                        succs.add(trans.getTreeTarget());
                        continue;
                    }
                    Iterables.addAll(succs, trans.getNonTreeTarget().subtreeLocations());
                }
                curr = new NonDetState(succs, curr.getStack());
            }
            ++i;
            if (curr.isNonDet()) continue;
            lastDet = i;
            lastDetState = curr;
        }
        if (lastDet < suffix.length()) {
            this.determinize(lastDetState.determinize(), suffix.subWord(lastDet));
        }
        return this.hypothesis.getSuccessor(baseState, suffix);
    }

    @Override
    protected boolean refineHypothesisSingle(DefaultQuery<I, Boolean> ceQuery) {
        Word ceWord = ceQuery.getInput();
        Boolean out = this.computeHypothesisOutput(ceWord);
        if (Objects.equals(out, ceQuery.getOutput())) {
            return false;
        }
        OutputInconsistency outIncons = new OutputInconsistency(this.hypothesis.getInitialLocation(), new ContextPair(Word.epsilon(), ceWord), ceQuery.getOutput());
        do {
            this.splitState(outIncons);
            this.closeTransitions();
            while (this.finalizeAny()) {
                this.closeTransitions();
            }
        } while ((outIncons = this.findOutputInconsistency()) != null);
        return true;
    }

    protected boolean computeHypothesisOutput(Word<I> word) {
        State<HypLoc<I>> curr = this.hypothesis.getInitialState();
        for (I sym : word) {
            curr = this.getAnySuccessor(curr, sym);
        }
        return this.hypothesis.isAccepting(curr);
    }

    private void splitState(OutputInconsistency<I> outIncons) {
        OPLearnerVPA.PrefixTransformAcex acex = this.deriveAcex(outIncons);
        int breakpoint = this.analyzer.analyzeAbstractCounterexample(acex);
        Word acexSuffix = acex.getSuffix();
        Word prefix = acexSuffix.prefix(breakpoint);
        Object act = acexSuffix.getSymbol(breakpoint);
        Word suffix = acexSuffix.subWord(breakpoint + 1);
        State state = this.hypothesis.getSuccessor(acex.getBaseState(), prefix);
        assert (state != null);
        State succState = this.hypothesis.getSuccessor(state, act);
        assert (succState != null);
        ContextPair context = new ContextPair(this.transformAccessSequence(succState.getStackContents()), suffix);
        AbstractHypTrans trans = this.hypothesis.getInternalTransition(state, act);
        assert (trans != null);
        HypLoc newLoc = this.makeTree(trans);
        DTNode oldDtNode = succState.getLocation().getLeaf();
        this.openTransitions.addAll(oldDtNode.getIncoming());
        AbstractDTNode.SplitResult children = oldDtNode.split(context, (Boolean)acex.effect(breakpoint), (Boolean)acex.effect(breakpoint + 1));
        oldDtNode.setTemp(true);
        if (!((DTNode)oldDtNode.getParent()).isTemp()) {
            this.blockList.add(oldDtNode);
        }
        TTTLearnerVPA.link((DTNode)children.nodeOld, newLoc);
        TTTLearnerVPA.link((DTNode)children.nodeNew, succState.getLocation());
        this.initializeLocation(newLoc);
    }

    protected boolean finalizeAny() {
        assert (this.openTransitions.isEmpty());
        GlobalSplitter<I> splitter = this.findSplitterGlobal();
        if (splitter != null) {
            this.finalizeDiscriminator(splitter.blockRoot, splitter.localSplitter);
            return true;
        }
        return false;
    }

    private @Nullable OutputInconsistency<I> findOutputInconsistency() {
        OutputInconsistency best = null;
        for (HypLoc loc : this.hypothesis.getLocations()) {
            int locAsLen = loc.getAccessSequence().length();
            DTNode node = loc.getLeaf();
            while (!node.isRoot()) {
                boolean hypOut;
                boolean expectedOut = (Boolean)node.getParentOutcome();
                node = (DTNode)node.getParent();
                ContextPair discr = (ContextPair)node.getDiscriminator();
                if (best != null && discr.getLength() + locAsLen >= best.totalLength() || (hypOut = this.computeHypothesisOutput(discr.getPrefix().concat(loc.getAccessSequence(), discr.getSuffix()))) == expectedOut) continue;
                best = new OutputInconsistency(loc, discr, expectedOut);
            }
        }
        return best;
    }

    protected State<HypLoc<I>> getAnySuccessor(State<HypLoc<I>> state, I sym) {
        VPAlphabet.SymbolType type = this.alphabet.getSymbolType(sym);
        StackContents stackContents = state.getStackContents();
        switch (type) {
            case INTERNAL: {
                AbstractHypTrans<I> trans = this.hypothesis.getInternalTransition(state.getLocation(), sym);
                HypLoc<I> succLoc = trans.isTree() ? trans.getTreeTarget() : trans.getNonTreeTarget().subtreeLocsIterator().next();
                return new State<HypLoc<I>>(succLoc, stackContents);
            }
            case CALL: {
                int stackSym = this.hypothesis.encodeStackSym(state.getLocation(), sym);
                return new State<Object>(this.hypothesis.getInitialLocation(), StackContents.push(stackSym, stackContents));
            }
            case RETURN: {
                assert (stackContents != null);
                AbstractHypTrans<I> trans = this.hypothesis.getReturnTransition(state.getLocation(), sym, stackContents.peek());
                HypLoc<I> succLoc = trans.isTree() ? trans.getTreeTarget() : trans.getNonTreeTarget().subtreeLocsIterator().next();
                return new State<HypLoc<I>>(succLoc, stackContents.pop());
            }
        }
        throw new IllegalStateException("Unhandled type " + (Object)((Object)type));
    }

    private OPLearnerVPA.PrefixTransformAcex deriveAcex(OutputInconsistency<I> outIncons) {
        OPLearnerVPA.PrefixTransformAcex acex = new OPLearnerVPA.PrefixTransformAcex(outIncons.location.getAccessSequence(), outIncons.discriminator);
        acex.setEffect(0, outIncons.expectedOut);
        acex.setEffect(acex.getLength() - 1, !outIncons.expectedOut);
        return acex;
    }

    private @Nullable GlobalSplitter<I> findSplitterGlobal() {
        DTNode bestBlockRoot = null;
        Splitter<I> bestSplitter = null;
        for (DTNode dTNode : this.blockList) {
            Splitter<I> splitter = this.findSplitter(dTNode);
            if (splitter == null || bestSplitter != null && splitter.getNewDiscriminatorLength() >= bestSplitter.getNewDiscriminatorLength()) continue;
            bestSplitter = splitter;
            bestBlockRoot = dTNode;
        }
        if (bestSplitter == null) {
            return null;
        }
        return new GlobalSplitter(bestBlockRoot, bestSplitter);
    }

    private void finalizeDiscriminator(DTNode<I> blockRoot, Splitter<I> splitter) {
        assert (blockRoot.isBlockRoot());
        ContextPair<I> newDiscr = splitter.getNewDiscriminator();
        assert (!((ContextPair)blockRoot.getDiscriminator()).equals(newDiscr));
        ContextPair<I> finalDiscriminator = this.prepareSplit(blockRoot, splitter);
        HashMap<Boolean, DTNode<I>> repChildren = new HashMap<Boolean, DTNode<I>>();
        for (Boolean label : blockRoot.getSplitData().getLabels()) {
            repChildren.put(label, this.extractSubtree(blockRoot, label));
        }
        blockRoot.replaceChildren(repChildren);
        blockRoot.setDiscriminator(finalDiscriminator);
        this.declareFinal(blockRoot);
    }

    private @Nullable Splitter<I> findSplitter(DTNode<I> blockRoot) {
        Object currLca;
        int i;
        int alphabetSize = this.alphabet.getNumInternals() + this.alphabet.getNumCalls() * this.alphabet.getNumReturns() * this.hypothesis.size() * 2;
        DTNode[] lcas = new DTNode[alphabetSize];
        for (HypLoc<I> loc : blockRoot.subtreeLocations()) {
            i = 0;
            for (Object intSym : this.alphabet.getInternalAlphabet()) {
                currLca = lcas[i];
                AbstractHypTrans<I> trans = this.hypothesis.getInternalTransition(loc, intSym);
                assert (trans.getTargetNode() != null);
                lcas[i] = currLca == null ? trans.getTargetNode() : this.dtree.leastCommonAncestor(currLca, trans.getTargetNode());
                ++i;
            }
            for (Object retSym : this.alphabet.getReturnAlphabet()) {
                for (Object callSym : this.alphabet.getCallAlphabet()) {
                    for (HypLoc stackLoc : this.hypothesis.getLocations()) {
                        AbstractHypTrans<I> trans = this.hypothesis.getReturnTransition(loc, retSym, stackLoc, callSym);
                        DTNode currLca2 = lcas[i];
                        assert (trans.getTargetNode() != null);
                        lcas[i] = currLca2 == null ? trans.getTargetNode() : this.dtree.leastCommonAncestor(currLca2, trans.getTargetNode());
                        trans = this.hypothesis.getReturnTransition(stackLoc, retSym, loc, callSym);
                        currLca2 = lcas[++i];
                        lcas[i] = currLca2 == null ? trans.getTargetNode() : this.dtree.leastCommonAncestor(currLca2, trans.getTargetNode());
                        ++i;
                    }
                }
            }
        }
        int shortestLen = Integer.MAX_VALUE;
        Splitter shortestSplitter = null;
        i = 0;
        for (Object intSym : this.alphabet.getInternalAlphabet()) {
            currLca = lcas[i];
            if (!((AbstractDTNode)currLca).isLeaf() && !((AbstractTemporaryIntrusiveDTNode)currLca).isTemp()) {
                Splitter splitter = new Splitter(intSym, currLca);
                int newLen = splitter.getNewDiscriminatorLength();
                if (shortestSplitter == null || shortestLen > newLen) {
                    shortestSplitter = splitter;
                    shortestLen = newLen;
                }
            }
            ++i;
        }
        for (Object retSym : this.alphabet.getReturnAlphabet()) {
            for (Object callSym : this.alphabet.getCallAlphabet()) {
                for (HypLoc stackLoc : this.hypothesis.getLocations()) {
                    int newLen;
                    Splitter splitter;
                    DTNode currLca3 = lcas[i];
                    assert (currLca3 != null);
                    if (!currLca3.isLeaf() && !currLca3.isTemp()) {
                        splitter = new Splitter(retSym, stackLoc, callSym, false, currLca3);
                        newLen = splitter.getNewDiscriminatorLength();
                        if (shortestSplitter == null || shortestLen > newLen) {
                            shortestSplitter = splitter;
                            shortestLen = newLen;
                        }
                    }
                    currLca3 = lcas[++i];
                    assert (currLca3 != null);
                    if (!currLca3.isLeaf() && !currLca3.isTemp()) {
                        splitter = new Splitter(callSym, stackLoc, retSym, true, currLca3);
                        newLen = splitter.getNewDiscriminatorLength();
                        if (shortestSplitter == null || shortestLen > newLen) {
                            shortestSplitter = splitter;
                            shortestLen = newLen;
                        }
                    }
                    ++i;
                }
            }
        }
        return shortestSplitter;
    }

    private ContextPair<I> prepareSplit(DTNode<I> node, Splitter<I> splitter) {
        ContextPair<I> discriminator = splitter.getNewDiscriminator();
        ArrayDeque<DTNode> dfsStack = new ArrayDeque<DTNode>();
        DTNode succSeparator = splitter.succSeparator;
        dfsStack.push(node);
        assert (node.getSplitData() == null);
        while (!dfsStack.isEmpty()) {
            Boolean outcome;
            AbstractHypTrans<I> trans2;
            DTNode curr = (DTNode)dfsStack.pop();
            assert (curr.getSplitData() == null);
            curr.setSplitData(new SplitData(TransList::new));
            for (AbstractHypTrans<I> trans2 : curr.getIncoming()) {
                outcome = this.query(trans2, discriminator);
                ((TransList)curr.getSplitData().getIncoming(outcome)).add(trans2);
                TTTLearnerVPA.markAndPropagate(curr, outcome);
            }
            if (curr.isInner()) {
                for (DTNode child : curr.getChildren()) {
                    dfsStack.push(child);
                }
                continue;
            }
            HypLoc loc = (HypLoc)curr.getData();
            assert (loc != null);
            trans2 = this.getSplitterTrans(loc, splitter);
            outcome = (Boolean)succSeparator.subtreeLabel(trans2.getTargetNode());
            assert (outcome != null);
            curr.getSplitData().setStateLabel(outcome);
            TTTLearnerVPA.markAndPropagate(curr, outcome);
        }
        return discriminator;
    }

    private DTNode<I> extractSubtree(DTNode<I> root, Boolean label) {
        assert (root.getSplitData() != null);
        assert (root.getSplitData().isMarked(label));
        ArrayDeque stack = new ArrayDeque();
        DTNode<I> firstExtracted = new DTNode<I>(root, label);
        stack.push(new ExtractRecord<I>(root, firstExtracted));
        while (!stack.isEmpty()) {
            ExtractRecord curr = (ExtractRecord)stack.pop();
            DTNode original = curr.original;
            DTNode extracted = curr.extracted;
            TTTLearnerVPA.moveIncoming(extracted, original, label);
            if (original.isLeaf()) {
                if (Objects.equals(original.getSplitData().getStateLabel(), label)) {
                    TTTLearnerVPA.link(extracted, (HypLoc)original.getData());
                } else {
                    this.createNewState(extracted);
                }
                extracted.updateIncoming();
            } else {
                ArrayList<DTNode> markedChildren = new ArrayList<DTNode>();
                for (DTNode child : original.getChildren()) {
                    if (!child.getSplitData().isMarked(label)) continue;
                    markedChildren.add(child);
                }
                if (markedChildren.size() > 1) {
                    HashMap childMap = new HashMap();
                    for (DTNode c : markedChildren) {
                        Boolean childLabel = (Boolean)c.getParentOutcome();
                        DTNode extractedChild = new DTNode(extracted, childLabel);
                        childMap.put(childLabel, extractedChild);
                        stack.push(new ExtractRecord(c, extractedChild));
                    }
                    extracted.split((ContextPair)original.getDiscriminator(), childMap);
                    extracted.updateIncoming();
                    extracted.setTemp(true);
                } else if (markedChildren.size() == 1) {
                    stack.push(new ExtractRecord((DTNode)markedChildren.get(0), extracted));
                } else {
                    this.createNewState(extracted);
                    extracted.updateIncoming();
                }
            }
            assert (extracted.getSplitData() == null);
        }
        return firstExtracted;
    }

    protected void declareFinal(DTNode<I> blockRoot) {
        blockRoot.setTemp(false);
        blockRoot.setSplitData(null);
        blockRoot.removeFromBlockList();
        for (DTNode subtree : blockRoot.getChildren()) {
            assert (subtree.getSplitData() == null);
            if (!subtree.isInner()) continue;
            this.blockList.add(subtree);
        }
        this.openTransitions.addAll(blockRoot.getIncoming());
    }

    private static <I> void markAndPropagate(DTNode<I> node, Boolean label) {
        for (DTNode curr = node; curr != null && curr.getSplitData() != null; curr = (DTNode)curr.getParent()) {
            if (curr.getSplitData().mark(label)) continue;
            return;
        }
    }

    public AbstractHypTrans<I> getSplitterTrans(HypLoc<I> loc, Splitter<I> splitter) {
        switch (splitter.type) {
            case INTERNAL: {
                return this.hypothesis.getInternalTransition(loc, splitter.symbol);
            }
            case RETURN: {
                return this.hypothesis.getReturnTransition(loc, splitter.symbol, splitter.location, splitter.otherSymbol);
            }
            case CALL: {
                return this.hypothesis.getReturnTransition(splitter.location, splitter.otherSymbol, loc, splitter.symbol);
            }
        }
        throw new IllegalStateException("Unhandled type " + (Object)((Object)splitter.type));
    }

    private static <I> void moveIncoming(DTNode<I> newNode, DTNode<I> oldNode, Boolean label) {
        newNode.getIncoming().addAll((TransList)oldNode.getSplitData().getIncoming(label));
    }

    private void createNewState(DTNode<I> newNode) {
        AbstractHypTrans<I> newTreeTrans = newNode.getIncoming().chooseMinimal();
        assert (newTreeTrans != null);
        HypLoc<I> newLoc = this.makeTree(newTreeTrans);
        TTTLearnerVPA.link(newNode, newLoc);
        this.initializeLocation(newLoc);
    }

    protected void determinize(State<HypLoc<I>> state, Word<I> suffix) {
        State<HypLoc<I>> curr = state;
        for (I sym : suffix) {
            if (!this.alphabet.isCallSymbol(sym)) {
                AbstractHypTrans<I> trans = this.hypothesis.getInternalTransition(curr, sym);
                assert (trans != null);
                if (!trans.isTree() && !trans.getNonTreeTarget().isLeaf()) {
                    this.updateDTTargets(Collections.singletonList(trans), true);
                }
            }
            curr = this.hypothesis.getSuccessor(curr, sym);
        }
    }
}

