/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.counterexample;

import de.learnlib.AccessSequenceTransformer;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.ClassicPrefixTransformAcex;
import de.learnlib.counterexample.LocalSuffixFinder;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.word.Word;

public class AcexLocalSuffixFinder
implements LocalSuffixFinder<Object, Object> {
    private final AcexAnalyzer analyzer;
    private final boolean reduce;
    private final String name;

    public AcexLocalSuffixFinder(AcexAnalyzer analyzer, boolean reduce, String name) {
        this.analyzer = analyzer;
        this.reduce = reduce;
        this.name = name;
    }

    @Override
    public <RI, RO> int findSuffixIndex(Query<RI, RO> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
        return AcexLocalSuffixFinder.findSuffixIndex(this.analyzer, this.reduce, ceQuery, asTransformer, hypOutput, oracle);
    }

    public static <RI, RO> int findSuffixIndex(AcexAnalyzer analyzer, boolean reduce, Query<RI, RO> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
        Word<RI> counterexample = ceQuery.getInput();
        ClassicPrefixTransformAcex<RI, RO> acex = new ClassicPrefixTransformAcex<RI, RO>(counterexample, oracle, hypOutput, asTransformer::transformAccessSequence);
        int start = 0;
        if (reduce) {
            start = asTransformer.longestASPrefix(counterexample).length();
        }
        int idx = analyzer.analyzeAbstractCounterexample(acex, start);
        return idx + 1;
    }

    public String toString() {
        return this.name;
    }
}

