/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable.writer;

import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.writer.AbstractObservationTableWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import net.automatalib.word.Word;

public class SuffixASCIIWriter<I, D>
extends AbstractObservationTableWriter<I, D> {
    private static final String WORD_DELIMITER = ";";
    private static final String SYMBOL_DELIMITER = ",";
    private static final Function<? super Word<?>, String> WORD_TO_STRING = is -> {
        if (is == null || is.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(SYMBOL_DELIMITER);
        for (Object symbol : is) {
            String stringRepresentation = Objects.toString(symbol);
            if (stringRepresentation.contains(SYMBOL_DELIMITER) || stringRepresentation.contains(WORD_DELIMITER)) {
                throw new IllegalArgumentException("Symbol '" + stringRepresentation + "' must not contain delimiters '" + SYMBOL_DELIMITER + "' or '" + WORD_DELIMITER + '\'');
            }
            joiner.add(stringRepresentation);
        }
        return joiner.toString();
    };

    public SuffixASCIIWriter() {
        super.setWordToString(WORD_TO_STRING);
    }

    @Override
    public void write(ObservationTable<? extends I, ? extends D> table, Appendable out) throws IOException {
        List<Word<I>> suffixes = table.getSuffixes();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Word<I> word : suffixes) {
            if (first) {
                first = false;
            } else {
                sb.append(WORD_DELIMITER);
            }
            String stringRepresentation = this.wordToString(word);
            if (stringRepresentation.contains(WORD_DELIMITER)) {
                throw new IllegalArgumentException("Delimiter ';' must not be used in symbol names. Symbol containing the delimiter was '" + stringRepresentation + '\'');
            }
            sb.append(stringRepresentation);
        }
        out.append(sb.toString());
    }
}

