/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta;

import de.learnlib.datastructure.pta.AbstractBlueFringePTAState;
import de.learnlib.datastructure.pta.BasePTA;
import de.learnlib.datastructure.pta.PTATransition;
import de.learnlib.datastructure.pta.RedBlueMerge;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBlueFringePTA<S extends AbstractBlueFringePTAState<S, SP, TP>, SP, TP>
extends BasePTA<S, SP, TP> {
    protected final List<S> redStates = new ArrayList<S>();

    public AbstractBlueFringePTA(int alphabetSize, S root) {
        super(alphabetSize, root);
    }

    public S getRedState(@NonNegative int id) {
        return (S)((AbstractBlueFringePTAState)this.redStates.get(id));
    }

    public @NonNegative int getNumRedStates() {
        return this.redStates.size();
    }

    public List<S> getRedStates() {
        return Collections.unmodifiableList(this.redStates);
    }

    public void init(Consumer<? super PTATransition<S>> newBlue) {
        AbstractBlueFringePTAState root = (AbstractBlueFringePTAState)this.getRoot();
        root.color = Color.BLUE;
        this.promote(root, newBlue);
    }

    public void promote(S qb, Consumer<? super PTATransition<S>> newBlue) {
        this.makeRed(qb);
        qb.forEachSucc(s2 -> newBlue.accept(s2.makeBlue()));
    }

    private void makeRed(S qb) {
        if (!((AbstractBlueFringePTAState)qb).isBlue()) {
            throw new IllegalArgumentException();
        }
        ((AbstractBlueFringePTAState)qb).makeRed(this.redStates.size());
        this.redStates.add(qb);
    }

    public @Nullable RedBlueMerge<S, SP, TP> tryMerge(S qr, S qb) {
        RedBlueMerge merge = new RedBlueMerge(this, qr, qb);
        if (!merge.merge()) {
            return null;
        }
        return merge;
    }
}

