/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta;

import com.google.common.collect.AbstractIterator;
import de.learnlib.datastructure.pta.AbstractBasePTAState;
import de.learnlib.datastructure.pta.PTATransition;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.automaton.FiniteAlphabetAutomaton;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.graph.UniversalAutomatonGraphView;
import net.automatalib.automaton.visualization.AutomatonVisualizationHelper;
import net.automatalib.common.smartcollection.IntSeq;
import net.automatalib.graph.UniversalGraph;
import net.automatalib.visualization.VisualizationHelper;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BasePTA<S extends AbstractBasePTAState<S, SP, TP>, SP, TP>
implements UniversalDeterministicAutomaton<S, Integer, PTATransition<S>, SP, TP>,
FiniteAlphabetAutomaton<S, Integer, PTATransition<S>> {
    private final int alphabetSize;
    private final S root;

    public BasePTA(int alphabetSize, S root) {
        this.alphabetSize = alphabetSize;
        this.root = (AbstractBasePTAState)Objects.requireNonNull(root);
    }

    public S getRoot() {
        return this.root;
    }

    @Override
    public Alphabet<Integer> getInputAlphabet() {
        return Alphabets.integers(0, this.alphabetSize - 1);
    }

    public void addSample(IntSeq sample, SP lastProperty) {
        S target = this.getOrCreateState(sample);
        ((AbstractBasePTAState)target).mergeStateProperty(lastProperty);
    }

    public S getOrCreateState(IntSeq word) {
        S curr = this.root;
        PrimitiveIterator.OfInt ofInt = word.iterator();
        while (ofInt.hasNext()) {
            int sym = (Integer)ofInt.next();
            curr = ((AbstractBasePTAState)curr).getOrCreateSuccessor(sym, this.alphabetSize);
        }
        return curr;
    }

    public void addSampleWithStateProperties(IntSeq sample, List<? extends SP> lastStateProperties) {
        int sampleLen = sample.size();
        int skip = sampleLen + 1 - lastStateProperties.size();
        if (skip < 0) {
            throw new IllegalArgumentException();
        }
        S curr = this.getRoot();
        int i = 0;
        while (i < skip) {
            int sym = sample.get(i++);
            curr = ((AbstractBasePTAState)curr).getOrCreateSuccessor(sym, this.alphabetSize);
        }
        Iterator<SP> spIt = lastStateProperties.iterator();
        while (i < sampleLen) {
            ((AbstractBasePTAState)curr).mergeStateProperty(spIt.next());
            int sym = sample.get(i++);
            curr = ((AbstractBasePTAState)curr).getOrCreateSuccessor(sym, this.alphabetSize);
        }
        ((AbstractBasePTAState)curr).mergeStateProperty(spIt.next());
    }

    public void addSampleWithTransitionProperties(IntSeq sample, List<? extends TP> lastTransitionProperties) {
        int sampleLen = sample.size();
        int skip = sampleLen - lastTransitionProperties.size();
        if (skip < 0) {
            throw new IllegalArgumentException();
        }
        S curr = this.getRoot();
        int i = 0;
        while (i < skip) {
            int sym = sample.get(i++);
            curr = ((AbstractBasePTAState)curr).getOrCreateSuccessor(sym, this.alphabetSize);
        }
        Iterator<TP> tpIt = lastTransitionProperties.iterator();
        while (i < sampleLen) {
            int sym = sample.get(i++);
            ((AbstractBasePTAState)curr).mergeTransitionProperty(sym, this.alphabetSize, tpIt.next());
            curr = ((AbstractBasePTAState)curr).getOrCreateSuccessor(sym, this.alphabetSize);
        }
    }

    @Override
    public S getSuccessor(PTATransition<S> transition) {
        return transition.getTarget();
    }

    @Override
    public @Nullable S getSuccessor(S state, Integer input) {
        return ((AbstractBasePTAState)state).getSuccessor(input);
    }

    @Override
    public Iterator<S> iterator() {
        final HashSet<S> visited = new HashSet<S>();
        final ArrayDeque<S> bfsQueue = new ArrayDeque<S>();
        bfsQueue.add(this.root);
        visited.add(this.root);
        return new AbstractIterator<S>(){

            @Override
            protected S computeNext() {
                AbstractBasePTAState next = (AbstractBasePTAState)bfsQueue.poll();
                if (next == null) {
                    return (AbstractBasePTAState)this.endOfData();
                }
                for (int i = 0; i < BasePTA.this.alphabetSize; ++i) {
                    Object child = next.getSuccessor(i);
                    if (child == null || !visited.add(child)) continue;
                    bfsQueue.offer(child);
                }
                return next;
            }
        };
    }

    @Override
    public Collection<S> getStates() {
        ArrayList stateList = new ArrayList();
        HashSet visited = new HashSet();
        int ptr = 0;
        stateList.add(this.root);
        visited.add(this.root);
        int numStates = 1;
        while (ptr < numStates) {
            AbstractBasePTAState curr = (AbstractBasePTAState)stateList.get(ptr++);
            for (int i = 0; i < this.alphabetSize; ++i) {
                Object succ = curr.getSuccessor(i);
                if (succ == null || !visited.add(succ)) continue;
                stateList.add(succ);
                ++numStates;
            }
        }
        return stateList;
    }

    @Override
    public S getInitialState() {
        return this.getRoot();
    }

    @Override
    public @Nullable PTATransition<S> getTransition(S state, Integer input) {
        if (((AbstractBasePTAState)state).getSuccessor(input) == null) {
            return null;
        }
        return new PTATransition<S>(state, input);
    }

    @Override
    public SP getStateProperty(S state) {
        return ((AbstractBasePTAState)state).getStateProperty();
    }

    @Override
    public TP getTransitionProperty(PTATransition<S> transition) {
        return ((AbstractBasePTAState)transition.getSource()).getTransProperty(transition.getIndex());
    }

    @Override
    public UniversalGraph<S, TransitionEdge<Integer, PTATransition<S>>, SP, TransitionEdge.Property<Integer, TP>> transitionGraphView(Collection<? extends Integer> inputs) {
        return new UniversalAutomatonGraphView<S, Integer, PTATransition<S>, SP, TP, BasePTA<S, SP, TP>>(this, inputs){

            @Override
            public VisualizationHelper<S, TransitionEdge<Integer, PTATransition<S>>> getVisualizationHelper() {
                return new AutomatonVisualizationHelper<S, Integer, PTATransition<S>, BasePTA<S, SP, TP>>(BasePTA.this){

                    @Override
                    public boolean getEdgeProperties(S src, TransitionEdge<Integer, PTATransition<S>> edge, S tgt, Map<String, String> properties) {
                        super.getEdgeProperties(src, edge, tgt, properties);
                        Integer input = edge.getInput();
                        properties.put("label", input + " / " + ((AbstractBasePTAState)src).getTransProperty(input));
                        return true;
                    }

                    @Override
                    public boolean getNodeProperties(S node, Map<String, String> properties) {
                        super.getNodeProperties(node, properties);
                        properties.put("label", Objects.toString(((AbstractBasePTAState)node).getProperty()));
                        return true;
                    }
                };
            }
        };
    }
}

