/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta.wrapper;

import de.learnlib.datastructure.pta.AbstractBasePTAState;
import de.learnlib.datastructure.pta.BasePTA;
import de.learnlib.datastructure.pta.PTATransition;
import java.util.Collection;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.FiniteAlphabetAutomaton;
import net.automatalib.automaton.transducer.MealyMachine;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MealyWrapper<S extends AbstractBasePTAState<S, Void, O>, I, O>
implements MealyMachine<S, I, PTATransition<S>, O>,
FiniteAlphabetAutomaton<S, I, PTATransition<S>> {
    private final Alphabet<I> alphabet;
    private final BasePTA<S, Void, O> pta;

    public MealyWrapper(Alphabet<I> alphabet, BasePTA<S, Void, O> pta) {
        assert (alphabet.size() == pta.getInputAlphabet().size());
        this.alphabet = alphabet;
        this.pta = pta;
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public O getTransitionOutput(PTATransition<S> transition) {
        return this.pta.getTransitionProperty(transition);
    }

    @Override
    public Collection<S> getStates() {
        return this.pta.getStates();
    }

    @Override
    public @Nullable PTATransition<S> getTransition(S state, I input) {
        return this.pta.getTransition(state, this.alphabet.getSymbolIndex(input));
    }

    @Override
    public S getSuccessor(PTATransition<S> transition) {
        return this.pta.getSuccessor(transition);
    }

    @Override
    public S getInitialState() {
        return (S)this.pta.getInitialState();
    }
}

