/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.mealy;

import de.learnlib.Resumable;
import de.learnlib.filter.cache.DynamicSymbolComparator;
import de.learnlib.filter.cache.LearningCacheOracle;
import de.learnlib.filter.cache.ReverseLexCmp;
import de.learnlib.filter.cache.mealy.MasterQuery;
import de.learnlib.filter.cache.mealy.MealyCacheConsistencyTest;
import de.learnlib.logging.Category;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MealyCacheOracle<I, O>
implements LearningCacheOracle.MealyLearningCacheOracle<I, O>,
SupportsGrowingAlphabet<I>,
Resumable<MealyCacheOracleState<I, O>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MealyCacheOracle.class);
    private final MembershipOracle<I, Word<O>> delegate;
    private IncrementalMealyBuilder<I, O> incMealy;
    private final Comparator<? super Query<I, ?>> queryCmp;
    private final @Nullable Mapping<? super O, ? extends O> errorSyms;

    MealyCacheOracle(IncrementalMealyBuilder<I, O> incrementalBuilder, @Nullable Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate) {
        this(incrementalBuilder, errorSyms, delegate, new DynamicSymbolComparator());
    }

    MealyCacheOracle(IncrementalMealyBuilder<I, O> incrementalBuilder, @Nullable Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate, Comparator<I> comparator) {
        this.incMealy = incrementalBuilder;
        this.queryCmp = new ReverseLexCmp<I>(comparator);
        this.errorSyms = errorSyms;
        this.delegate = delegate;
    }

    public EquivalenceOracle.MealyEquivalenceOracle<I, O> createCacheConsistencyTest() {
        return new MealyCacheConsistencyTest<I, O>(this.incMealy);
    }

    @Override
    public void processQueries(Collection<? extends Query<I, Word<O>>> queries) {
        if (queries.isEmpty()) {
            return;
        }
        ArrayList<Query<I, Word<O>>> qrys = new ArrayList<Query<I, Word<O>>>(queries);
        qrys.sort(this.queryCmp);
        List<MasterQuery<I, O>> masterQueries = this.queryCache(qrys);
        this.delegate.processQueries(masterQueries);
        this.updateCache(masterQueries);
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        this.incMealy.addAlphabetSymbol(symbol);
    }

    @Override
    public MealyCacheOracleState<I, O> suspend() {
        return new MealyCacheOracleState<I, O>(this.incMealy);
    }

    @Override
    public void resume(MealyCacheOracleState<I, O> state) {
        Class<?> stateClass;
        Class<?> thisClass = this.incMealy.getClass();
        if (!thisClass.equals(stateClass = state.getBuilder().getClass())) {
            LOGGER.warn(Category.DATASTRUCTURE, "You currently plan to use a '{}', but the state contained a '{}'. This may yield unexpected behavior.", (Object)thisClass, (Object)stateClass);
        }
        this.incMealy = state.getBuilder();
    }

    List<MasterQuery<I, O>> queryCache(Collection<? extends Query<I, Word<O>>> queries) {
        ArrayList<MasterQuery<I, O>> masterQueries = new ArrayList<MasterQuery<I, O>>();
        Iterator<Query<I, Word<O>>> it = queries.iterator();
        Query<I, Word<O>> q = it.next();
        Word<I> ref = q.getInput();
        MasterQuery<I, O> master = this.createMasterQuery(ref);
        if (!master.isAnswered()) {
            masterQueries.add(master);
        }
        master.addSlave(q);
        while (it.hasNext()) {
            q = it.next();
            Word<I> curr = q.getInput();
            if (!curr.isPrefixOf(ref) && !(master = this.createMasterQuery(curr)).isAnswered()) {
                masterQueries.add(master);
            }
            master.addSlave(q);
            ref = curr;
        }
        return masterQueries;
    }

    private MasterQuery<I, O> createMasterQuery(Word<I> word) {
        WordBuilder<O> wb = new WordBuilder<O>(word.size());
        if (this.incMealy.lookup(word, wb)) {
            return new MasterQuery(word, wb.toWord());
        }
        if (this.errorSyms == null) {
            return new MasterQuery(word);
        }
        int wbSize = wb.size();
        if (wbSize == 0) {
            return new MasterQuery<I, O>(word, this.errorSyms);
        }
        O repSym = this.errorSyms.get(wb.getSymbol(wbSize - 1));
        if (repSym == null) {
            return new MasterQuery<I, O>(word, this.errorSyms);
        }
        wb.repeatAppend(word.length() - wbSize, repSym);
        return new MasterQuery(word, wb.toWord());
    }

    void updateCache(Collection<? extends MasterQuery<I, O>> queries) {
        for (MasterQuery<I, O> m3 : queries) {
            this.postProcess(m3);
        }
    }

    private void postProcess(MasterQuery<I, O> master) {
        O sym;
        Word word = master.getSuffix();
        Word<O> answer = master.getAnswer();
        if (this.errorSyms == null) {
            this.incMealy.insert(word, answer);
            return;
        }
        int answLen = answer.length();
        int i = 0;
        while (i < answLen && this.errorSyms.get(sym = answer.getSymbol(i++)) == null) {
        }
        if (i == answLen) {
            this.incMealy.insert(word, answer);
        } else {
            this.incMealy.insert(word.prefix(i), answer.prefix(i));
        }
    }

    public static class MealyCacheOracleState<I, O> {
        private final IncrementalMealyBuilder<I, O> builder;

        MealyCacheOracleState(IncrementalMealyBuilder<I, O> builder) {
            this.builder = builder;
        }

        IncrementalMealyBuilder<I, O> getBuilder() {
            return this.builder;
        }
    }
}

