/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.mealy;

import de.learnlib.filter.cache.mealy.MasterQuery;
import de.learnlib.filter.cache.mealy.MealyCacheOracle;
import de.learnlib.filter.cache.mealy.ThreadSafeMealyCacheConsistencyTest;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ThreadSafeMealyCacheOracle<I, O>
extends MealyCacheOracle<I, O> {
    private final ReadWriteLock lock;

    ThreadSafeMealyCacheOracle(IncrementalMealyBuilder<I, O> incMealy, @Nullable Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate, ReadWriteLock lock) {
        super(incMealy, errorSyms, delegate);
        this.lock = lock;
    }

    ThreadSafeMealyCacheOracle(IncrementalMealyBuilder<I, O> incMealy, @Nullable Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate, Comparator<I> comparator, ReadWriteLock lock) {
        super(incMealy, errorSyms, delegate, comparator);
        this.lock = lock;
    }

    @Override
    List<MasterQuery<I, O>> queryCache(Collection<? extends Query<I, Word<O>>> queries) {
        this.lock.readLock().lock();
        try {
            List list = super.queryCache(queries);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    void updateCache(Collection<? extends MasterQuery<I, O>> masterQueries) {
        this.lock.writeLock().lock();
        try {
            super.updateCache(masterQueries);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public EquivalenceOracle.MealyEquivalenceOracle<I, O> createCacheConsistencyTest() {
        return new ThreadSafeMealyCacheConsistencyTest(super.createCacheConsistencyTest(), this.lock);
    }
}

