/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.mealy;

import de.learnlib.filter.cache.mealy.ThreadSafeMealyCacheOracle;
import de.learnlib.oracle.MembershipOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.incremental.mealy.dag.IncrementalMealyDAGBuilder;
import net.automatalib.incremental.mealy.tree.DynamicIncrementalMealyTreeBuilder;
import net.automatalib.incremental.mealy.tree.IncrementalMealyTreeBuilder;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ThreadSafeMealyCaches {
    private ThreadSafeMealyCaches() {
    }

    public static <I, O> Supplier<ThreadSafeMealyCacheOracle<I, O>> createDAGCache(Alphabet<I> alphabet, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier) {
        return ThreadSafeMealyCaches.createDAGCache(alphabet, null, oracleSupplier);
    }

    public static <I, O> Supplier<ThreadSafeMealyCacheOracle<I, O>> createDAGCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier) {
        Function<Alphabet, IncrementalMealyBuilder> builder = IncrementalMealyDAGBuilder::new;
        return ThreadSafeMealyCaches.createSupplierBasedCache(alphabet, errorSyms, oracleSupplier, builder);
    }

    public static <I, O> Collection<ThreadSafeMealyCacheOracle<I, O>> createDAGCache(Alphabet<I> alphabet, Collection<? extends MembershipOracle<I, Word<O>>> oracles) {
        return ThreadSafeMealyCaches.createDAGCache(alphabet, null, oracles);
    }

    public static <I, O> Collection<ThreadSafeMealyCacheOracle<I, O>> createDAGCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Collection<? extends MembershipOracle<I, Word<O>>> oracles) {
        Function<Alphabet, IncrementalMealyBuilder> builder = IncrementalMealyDAGBuilder::new;
        return ThreadSafeMealyCaches.createCollectionBasedCache(alphabet, errorSyms, oracles, builder);
    }

    public static <I, O> Supplier<ThreadSafeMealyCacheOracle<I, O>> createTreeCache(Alphabet<I> alphabet, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier) {
        return ThreadSafeMealyCaches.createTreeCache(alphabet, null, oracleSupplier);
    }

    public static <I, O> Supplier<ThreadSafeMealyCacheOracle<I, O>> createTreeCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier) {
        Function<Alphabet, IncrementalMealyBuilder> builder = IncrementalMealyTreeBuilder::new;
        return ThreadSafeMealyCaches.createSupplierBasedCache(alphabet, errorSyms, oracleSupplier, builder);
    }

    public static <I, O> Collection<ThreadSafeMealyCacheOracle<I, O>> createTreeCache(Alphabet<I> alphabet, Collection<? extends MembershipOracle<I, Word<O>>> oracles) {
        return ThreadSafeMealyCaches.createTreeCache(alphabet, null, oracles);
    }

    public static <I, O> Collection<ThreadSafeMealyCacheOracle<I, O>> createTreeCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Collection<? extends MembershipOracle<I, Word<O>>> oracles) {
        Function<Alphabet, IncrementalMealyBuilder> builder = IncrementalMealyTreeBuilder::new;
        return ThreadSafeMealyCaches.createCollectionBasedCache(alphabet, errorSyms, oracles, builder);
    }

    public static <I, O> Supplier<ThreadSafeMealyCacheOracle<I, O>> createDynamicTreeCache(Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier) {
        return ThreadSafeMealyCaches.createDynamicTreeCache(null, oracleSupplier);
    }

    public static <I, O> Supplier<ThreadSafeMealyCacheOracle<I, O>> createDynamicTreeCache(@Nullable Mapping<? super O, ? extends O> errorSyms, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        DynamicIncrementalMealyTreeBuilder incremental = new DynamicIncrementalMealyTreeBuilder();
        return () -> new ThreadSafeMealyCacheOracle(incremental, errorSyms, (MembershipOracle)oracleSupplier.get(), lock);
    }

    public static <I, O> Collection<ThreadSafeMealyCacheOracle<I, O>> createDynamicTreeCache(Collection<? extends MembershipOracle<I, Word<O>>> oracles) {
        return ThreadSafeMealyCaches.createDynamicTreeCache(null, oracles);
    }

    public static <I, O> Collection<ThreadSafeMealyCacheOracle<I, O>> createDynamicTreeCache(@Nullable Mapping<? super O, ? extends O> errorSyms, Collection<? extends MembershipOracle<I, Word<O>>> oracles) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        DynamicIncrementalMealyTreeBuilder incremental = new DynamicIncrementalMealyTreeBuilder();
        ArrayList<ThreadSafeMealyCacheOracle<I, O>> result = new ArrayList<ThreadSafeMealyCacheOracle<I, O>>(oracles.size());
        for (MembershipOracle<I, Word<O>> oracle : oracles) {
            result.add(new ThreadSafeMealyCacheOracle(incremental, errorSyms, oracle, lock));
        }
        return result;
    }

    private static <I, O> Supplier<ThreadSafeMealyCacheOracle<I, O>> createSupplierBasedCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier, Function<? super Alphabet<I>, ? extends IncrementalMealyBuilder<I, O>> builder) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        IncrementalMealyBuilder incremental = builder.apply(alphabet);
        return () -> new ThreadSafeMealyCacheOracle(incremental, errorSyms, (MembershipOracle)oracleSupplier.get(), lock);
    }

    private static <I, O> Collection<ThreadSafeMealyCacheOracle<I, O>> createCollectionBasedCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Collection<? extends MembershipOracle<I, Word<O>>> oracles, Function<? super Alphabet<I>, ? extends IncrementalMealyBuilder<I, O>> builder) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        IncrementalMealyBuilder<I, O> incremental = builder.apply(alphabet);
        ArrayList<ThreadSafeMealyCacheOracle<I, O>> result = new ArrayList<ThreadSafeMealyCacheOracle<I, O>>(oracles.size());
        for (MembershipOracle<I, Word<O>> oracle : oracles) {
            result.add(new ThreadSafeMealyCacheOracle<I, O>(incremental, errorSyms, oracle, alphabet, lock));
        }
        return result;
    }
}

