/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.moore;

import de.learnlib.filter.cache.moore.MasterQuery;
import de.learnlib.filter.cache.moore.MooreCacheOracle;
import de.learnlib.filter.cache.moore.ThreadSafeMooreCacheConsistencyTest;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.incremental.moore.IncrementalMooreBuilder;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ThreadSafeMooreCacheOracle<I, O>
extends MooreCacheOracle<I, O> {
    private final ReadWriteLock lock;

    ThreadSafeMooreCacheOracle(IncrementalMooreBuilder<I, O> incMoore, @Nullable Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate, ReadWriteLock lock) {
        super(incMoore, errorSyms, delegate);
        this.lock = lock;
    }

    ThreadSafeMooreCacheOracle(IncrementalMooreBuilder<I, O> incMoore, @Nullable Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate, Comparator<I> comparator, ReadWriteLock lock) {
        super(incMoore, errorSyms, delegate, comparator);
        this.lock = lock;
    }

    @Override
    List<MasterQuery<I, O>> queryCache(Collection<? extends Query<I, Word<O>>> queries) {
        this.lock.readLock().lock();
        try {
            List list = super.queryCache(queries);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    void updateCache(Collection<? extends MasterQuery<I, O>> masterQueries) {
        this.lock.writeLock().lock();
        try {
            super.updateCache(masterQueries);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public EquivalenceOracle.MooreEquivalenceOracle<I, O> createCacheConsistencyTest() {
        return new ThreadSafeMooreCacheConsistencyTest(super.createCacheConsistencyTest(), this.lock);
    }
}

