/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.moore;

import de.learnlib.filter.cache.moore.ThreadSafeMooreCacheOracle;
import de.learnlib.oracle.MembershipOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.incremental.moore.IncrementalMooreBuilder;
import net.automatalib.incremental.moore.dag.IncrementalMooreDAGBuilder;
import net.automatalib.incremental.moore.tree.IncrementalMooreTreeBuilder;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ThreadSafeMooreCaches {
    private ThreadSafeMooreCaches() {
    }

    public static <I, O> Supplier<ThreadSafeMooreCacheOracle<I, O>> createDAGCache(Alphabet<I> alphabet, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier) {
        return ThreadSafeMooreCaches.createDAGCache(alphabet, null, oracleSupplier);
    }

    public static <I, O> Supplier<ThreadSafeMooreCacheOracle<I, O>> createDAGCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier) {
        Function<Alphabet, IncrementalMooreBuilder> builder = IncrementalMooreDAGBuilder::new;
        return ThreadSafeMooreCaches.createSupplierBasedCache(alphabet, errorSyms, oracleSupplier, builder);
    }

    public static <I, O> Collection<ThreadSafeMooreCacheOracle<I, O>> createDAGCache(Alphabet<I> alphabet, Collection<? extends MembershipOracle<I, Word<O>>> oracles) {
        return ThreadSafeMooreCaches.createDAGCache(alphabet, null, oracles);
    }

    public static <I, O> Collection<ThreadSafeMooreCacheOracle<I, O>> createDAGCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Collection<? extends MembershipOracle<I, Word<O>>> oracles) {
        Function<Alphabet, IncrementalMooreBuilder> builder = IncrementalMooreDAGBuilder::new;
        return ThreadSafeMooreCaches.createCollectionBasedCache(alphabet, errorSyms, oracles, builder);
    }

    public static <I, O> Supplier<ThreadSafeMooreCacheOracle<I, O>> createTreeCache(Alphabet<I> alphabet, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier) {
        return ThreadSafeMooreCaches.createTreeCache(alphabet, null, oracleSupplier);
    }

    public static <I, O> Supplier<ThreadSafeMooreCacheOracle<I, O>> createTreeCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier) {
        Function<Alphabet, IncrementalMooreBuilder> builder = IncrementalMooreTreeBuilder::new;
        return ThreadSafeMooreCaches.createSupplierBasedCache(alphabet, errorSyms, oracleSupplier, builder);
    }

    public static <I, O> Collection<ThreadSafeMooreCacheOracle<I, O>> createTreeCache(Alphabet<I> alphabet, Collection<? extends MembershipOracle<I, Word<O>>> oracles) {
        return ThreadSafeMooreCaches.createTreeCache(alphabet, null, oracles);
    }

    public static <I, O> Collection<ThreadSafeMooreCacheOracle<I, O>> createTreeCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Collection<? extends MembershipOracle<I, Word<O>>> oracles) {
        Function<Alphabet, IncrementalMooreBuilder> builder = IncrementalMooreTreeBuilder::new;
        return ThreadSafeMooreCaches.createCollectionBasedCache(alphabet, errorSyms, oracles, builder);
    }

    private static <I, O> Supplier<ThreadSafeMooreCacheOracle<I, O>> createSupplierBasedCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Supplier<? extends MembershipOracle<I, Word<O>>> oracleSupplier, Function<? super Alphabet<I>, ? extends IncrementalMooreBuilder<I, O>> builder) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        IncrementalMooreBuilder incremental = builder.apply(alphabet);
        return () -> new ThreadSafeMooreCacheOracle(incremental, errorSyms, (MembershipOracle)oracleSupplier.get(), lock);
    }

    private static <I, O> Collection<ThreadSafeMooreCacheOracle<I, O>> createCollectionBasedCache(Alphabet<I> alphabet, @Nullable Mapping<? super O, ? extends O> errorSyms, Collection<? extends MembershipOracle<I, Word<O>>> oracles, Function<? super Alphabet<I>, ? extends IncrementalMooreBuilder<I, O>> builder) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        IncrementalMooreBuilder<I, O> incremental = builder.apply(alphabet);
        ArrayList<ThreadSafeMooreCacheOracle<I, O>> result = new ArrayList<ThreadSafeMooreCacheOracle<I, O>>(oracles.size());
        for (MembershipOracle<I, Word<O>> oracle : oracles) {
            result.add(new ThreadSafeMooreCacheOracle<I, O>(incremental, errorSyms, oracle, alphabet, lock));
        }
        return result;
    }
}

