/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.sul;

import de.learnlib.filter.cache.sul.AbstractSULCache;
import de.learnlib.sul.StateLocalInputSUL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.word.WordBuilder;

public class StateLocalInputSULCache<I, O>
extends AbstractSULCache<I, O, StateLocalInputSULCacheState<I, O>>
implements StateLocalInputSUL<I, O> {
    private final StateLocalInputSULCacheImpl<?, I, ?, O> impl;

    StateLocalInputSULCache(IncrementalMealyBuilder<I, O> incMealy, StateLocalInputSUL<I, O> sul) {
        this(new StateLocalInputSULCacheImpl(incMealy, incMealy.asTransitionSystem(), sul));
    }

    <S, T> StateLocalInputSULCache(StateLocalInputSULCacheImpl<S, I, T, O> cacheImpl) {
        super(cacheImpl);
        this.impl = cacheImpl;
    }

    @Override
    public StateLocalInputSUL<I, O> fork() {
        return this.impl.fork();
    }

    @Override
    public Collection<I> currentlyEnabledInputs() {
        return this.impl.currentlyEnabledInputs();
    }

    public static final class StateLocalInputSULCacheState<I, O>
    extends AbstractSULCache.SULCacheState<I, O> {
        final Map<?, Collection<I>> enabledInputCache;

        StateLocalInputSULCacheState(IncrementalMealyBuilder<I, O> builder, Map<?, Collection<I>> enabledInputCache) {
            super(builder);
            this.enabledInputCache = enabledInputCache;
        }
    }

    static class StateLocalInputSULCacheImpl<S, I, T, O>
    extends AbstractSULCache.AbstractSULCacheImpl<S, I, T, O, StateLocalInputSULCacheState<I, O>>
    implements StateLocalInputSUL<I, O> {
        protected final StateLocalInputSUL<I, O> delegate;
        private S initialState;
        protected Map<S, Collection<I>> enabledInputCache;
        private final List<Collection<I>> inputsTrace;

        StateLocalInputSULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, MealyTransitionSystem<S, I, T, O> mealyTs, StateLocalInputSUL<I, O> sul) {
            this(incMealy, mealyTs, new HashMap(), sul);
        }

        StateLocalInputSULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, MealyTransitionSystem<S, I, T, O> mealyTs, Map<S, Collection<I>> enabledInputCache, StateLocalInputSUL<I, O> sul) {
            super(incMealy, mealyTs, sul);
            this.delegate = sul;
            Object init = mealyTs.getInitialState();
            assert (init != null);
            this.initialState = init;
            this.enabledInputCache = enabledInputCache;
            this.inputsTrace = new ArrayList<Collection<I>>();
        }

        @Override
        protected void postNewStepHook() {
            this.inputsTrace.add(this.delegate.currentlyEnabledInputs());
        }

        @Override
        protected void updateCache(WordBuilder<I> input, WordBuilder<O> output) {
            super.updateCache(input, output);
            int prefixLength = input.size() - this.inputsTrace.size();
            S iter = this.mealyTs.getSuccessor(this.initialState, input.subList(0, prefixLength));
            assert (iter != null);
            for (int i = 0; i < this.inputsTrace.size(); ++i) {
                iter = this.mealyTs.getSuccessor(iter, input.get(i + prefixLength));
                assert (iter != null);
                this.enabledInputCache.put(iter, this.inputsTrace.get(i));
            }
            this.inputsTrace.clear();
        }

        @Override
        public Collection<I> currentlyEnabledInputs() {
            Collection<I> inputs;
            if (this.current == this.initialState) {
                Collection<I> initialInputs = this.enabledInputCache.get(this.initialState);
                if (initialInputs == null) {
                    super.requiredInitializedDelegate();
                    initialInputs = this.delegate.currentlyEnabledInputs();
                    this.enabledInputCache.put(this.initialState, initialInputs);
                }
                return initialInputs;
            }
            if (this.current != null && (inputs = this.enabledInputCache.get(this.current)) != null) {
                return inputs;
            }
            return this.inputsTrace.get(this.inputsTrace.size() - 1);
        }

        @Override
        public StateLocalInputSULCacheState<I, O> suspend() {
            return new StateLocalInputSULCacheState(this.incMealy, this.enabledInputCache);
        }

        @Override
        public void resume(StateLocalInputSULCacheState<I, O> state) {
            super.resume(state);
            Object init = this.mealyTs.getInitialState();
            assert (init != null);
            this.initialState = init;
            this.enabledInputCache = state.enabledInputCache;
        }
    }
}

