/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.mapper;

import de.learnlib.exception.MappedException;
import de.learnlib.exception.SULException;
import de.learnlib.sul.SUL;
import de.learnlib.sul.SULMapper;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MappedSUL<AI, AO, CI, CO>
implements SUL<AI, AO> {
    private final SULMapper<? super AI, ? extends AO, ? extends CI, ? super CO> mapper;
    private final SUL<? super CI, ? extends CO> sul;
    private boolean inError;
    private @Nullable AO repeatedErrorOutput;

    public MappedSUL(SULMapper<? super AI, ? extends AO, ? extends CI, ? super CO> mapper, SUL<? super CI, ? extends CO> sul) {
        this.mapper = mapper;
        this.sul = sul;
    }

    @Override
    public void pre() {
        this.inError = false;
        this.repeatedErrorOutput = null;
        this.mapper.pre();
        this.sul.pre();
    }

    @Override
    public void post() {
        this.sul.post();
        this.mapper.post();
    }

    @Override
    public AO step(AI in) {
        MappedException<AO> mappedEx;
        if (this.inError) {
            return this.repeatedErrorOutput;
        }
        Object concreteInput = this.mapper.mapInput(in);
        try {
            CO concreteOutput = this.sul.step(concreteInput);
            return this.mapper.mapOutput(concreteOutput);
        }
        catch (SULException ex) {
            mappedEx = this.mapper.mapWrappedException(ex);
        }
        catch (RuntimeException ex) {
            mappedEx = this.mapper.mapUnwrappedException(ex);
        }
        Optional<AO> repeatOutput = mappedEx.getSubsequentStepsOutput();
        if (repeatOutput.isPresent()) {
            this.inError = true;
            this.repeatedErrorOutput = repeatOutput.get();
        }
        return mappedEx.getThisStepOutput();
    }

    @Override
    public boolean canFork() {
        return this.mapper.canFork() && this.sul.canFork();
    }

    public MappedSUL<AI, AO, CI, CO> fork() {
        return new MappedSUL<AI, AO, CI, CO>(this.mapper.fork(), this.sul.fork());
    }
}

