/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.parallelism;

import com.google.common.base.Throwables;
import de.learnlib.oracle.parallelism.BatchInterruptedException;
import de.learnlib.oracle.parallelism.BatchProcessor;
import de.learnlib.oracle.parallelism.DynamicQueriesJob;
import de.learnlib.oracle.parallelism.ThreadPool;
import de.learnlib.setting.LearnLibProperty;
import de.learnlib.setting.LearnLibSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.checkerframework.checker.index.qual.NonNegative;

public abstract class AbstractDynamicBatchProcessor<Q, P extends BatchProcessor<Q>>
implements ThreadPool,
BatchProcessor<Q> {
    public static final int BATCH_SIZE;
    public static final int POOL_SIZE;
    public static final ThreadPool.PoolPolicy POOL_POLICY;
    private final ThreadLocal<P> threadLocalOracle;
    private final ExecutorService executor;
    private final @NonNegative int batchSize;

    public AbstractDynamicBatchProcessor(Supplier<? extends P> oracleSupplier, @NonNegative int batchSize, ExecutorService executor) {
        this.threadLocalOracle = ThreadLocal.withInitial(oracleSupplier);
        this.executor = executor;
        this.batchSize = batchSize;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    @Override
    public void processBatch(Collection<? extends Q> queries) {
        if (queries.isEmpty()) {
            return;
        }
        int numQueries = queries.size();
        int numJobs = (numQueries - 1) / this.batchSize + 1;
        ArrayList<Q> currentBatch = null;
        ArrayList<Object> futures = new ArrayList<Object>(numJobs);
        for (Q q : queries) {
            if (currentBatch == null) {
                currentBatch = new ArrayList<Q>(this.batchSize);
            }
            currentBatch.add(q);
            if (currentBatch.size() != this.batchSize) continue;
            Future<?> future = this.executor.submit(new DynamicQueriesJob(currentBatch, this.threadLocalOracle));
            futures.add(future);
            currentBatch = null;
        }
        if (currentBatch != null) {
            Future<?> future = this.executor.submit(new DynamicQueriesJob(currentBatch, this.threadLocalOracle));
            futures.add(future);
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked(e.getCause());
            throw new AssertionError("Runnables must not throw checked exceptions", e);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new BatchInterruptedException(e);
        }
    }

    protected P getProcessor() {
        return (P)((BatchProcessor)this.threadLocalOracle.get());
    }

    static {
        LearnLibSettings settings = LearnLibSettings.getInstance();
        int numProcessors = Runtime.getRuntime().availableProcessors();
        BATCH_SIZE = settings.getInt(LearnLibProperty.PARALLEL_BATCH_SIZE_DYNAMIC, 1);
        POOL_SIZE = settings.getInt(LearnLibProperty.PARALLEL_POOL_SIZE, numProcessors);
        POOL_POLICY = settings.getEnumValue(LearnLibProperty.PARALLEL_POOL_POLICY, ThreadPool.PoolPolicy.class, ThreadPool.PoolPolicy.CACHED);
    }
}

