/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util;

import de.learnlib.oracle.AutomatonOracle;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.LinkedList;
import java.util.Queue;
import net.automatalib.automaton.DeterministicAutomaton;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBFOracle<A extends DeterministicAutomaton<?, I, ?>, I, D>
implements AutomatonOracle<A, I, D> {
    private final Queue<Word<I>> queue = new LinkedList<Word<I>>();
    private final MembershipOracle<I, D> membershipOracle;
    private double multiplier;

    protected AbstractBFOracle(MembershipOracle<I, D> membershipOracle, double multiplier) {
        this.membershipOracle = membershipOracle;
        this.multiplier = multiplier;
    }

    @Override
    public DefaultQuery<I, D> processInput(A hypothesis, Word<I> input) {
        DefaultQuery query = new DefaultQuery(input);
        this.membershipOracle.processQuery(query);
        return query;
    }

    @Override
    public double getMultiplier() {
        return this.multiplier;
    }

    @Override
    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public MembershipOracle<I, D> getMembershipOracle() {
        return this.membershipOracle;
    }

    @Override
    public @Nullable Word<I> nextInput() {
        return this.queue.poll();
    }

    @Override
    public void addWord(Word<I> input) {
        this.queue.add(input);
    }

    @Override
    public void pre() {
        this.queue.clear();
        this.addWord(Word.epsilon());
    }
}

