/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.algorithms.shortestpath.ShortestPath;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ShortestPathUtils {
    public static <V, E> List<E> getPath(Graph<V, E> graph, ShortestPath<V, E> sp, V source, V target) {
        LinkedList<E> path = new LinkedList<E>();
        Map<V, E> incomingEdges = sp.getIncomingEdgeMap(source);
        if (incomingEdges.isEmpty() || incomingEdges.get(target) == null) {
            return path;
        }
        V current = target;
        while (!current.equals(source)) {
            E incoming = incomingEdges.get(current);
            path.addFirst(incoming);
            Pair<V> endpoints = graph.getEndpoints(incoming);
            if (endpoints.getFirst().equals(current)) {
                current = endpoints.getSecond();
                continue;
            }
            current = endpoints.getFirst();
        }
        return path;
    }
}

