/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.codegenerator;

import info.scce.addlib.codegenerator.CodeGenerator;
import info.scce.addlib.dd.DD;
import info.scce.addlib.dd.LabelledRegularDD;
import info.scce.addlib.dd.RegularDD;
import info.scce.addlib.traverser.PreorderTraverser;
import java.io.PrintWriter;
import java.util.List;

public class PythonGenerator<D extends RegularDD<?, D>>
extends CodeGenerator<D> {
    private String paramClassName = "ADDLibDecisionService";

    public PythonGenerator<D> withClassName(String cla) {
        this.paramClassName = cla;
        return this;
    }

    @Override
    public void generate(PrintWriter out, List<LabelledRegularDD<D>> roots) {
        out.println("# This file was generated with the ADD-Lib");
        out.println("# http://add-lib.scce.info/");
        out.println();
        out.print("class ");
        if (this.paramClassName != null) {
            out.print(this.paramClassName);
        }
        out.println(":");
        for (LabelledRegularDD<D> x0 : roots) {
            out.println();
            out.print("    def ");
            out.print(x0.label());
            out.print("(self,");
            this.paramList(out);
            out.println("):");
            out.print("        return self.__eval");
            out.print(((DD)x0.dd()).ptr());
            out.println("(predicates)");
            out.println("    ");
        }
        for (RegularDD x1 : new PreorderTraverser<D>(this.unlabelledRoots(roots))) {
            if (x1.isConstant()) continue;
            out.println();
            out.println();
            out.print("    def __eval");
            out.print(x1.ptr());
            out.print("(self,");
            this.paramList(out);
            out.println("):");
            out.print("        if (");
            this.varCondition(out, x1);
            out.println("):");
            out.print("            return self.__eval");
            out.print(((RegularDD)x1.t()).ptr());
            out.println("(predicates)");
            out.println("        else:");
            out.print("            return self.__eval");
            out.print(((RegularDD)x1.e()).ptr());
            out.println("(predicates)");
        }
        for (RegularDD x2 : new PreorderTraverser<D>(this.unlabelledRoots(roots))) {
            if (!x2.isConstant()) continue;
            out.println();
            out.print("    def __eval");
            out.print(x2.ptr());
            out.print("(self,");
            this.paramList(out);
            out.println("):");
            out.print("        return ");
            this.resultInstatiation(out, x2);
            out.println("    ");
        }
        out.println("\t");
    }

    protected void paramList(PrintWriter out) {
        out.print("predicates");
    }

    protected void resultInstatiation(PrintWriter out, D x2) {
        out.print("\"");
        out.print(((DD)x2).toString());
        out.print("\"");
    }

    protected void varCondition(PrintWriter out, D x1) {
        out.print("predicates.");
        out.print(this.transformToValidLabel(((DD)x1).readName(), ((DD)x1).readIndex()));
        out.print("()");
    }
}

