/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd;

import info.scce.addlib.dd.DDException;
import info.scce.addlib.dd.DDManager;
import info.scce.addlib.dd.DDManagerException;
import info.scce.addlib.util.Conversions;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class DD<M extends DDManager<D, ?>, D extends DD<?, D>> {
    protected final long ptr;
    protected final M ddManager;

    public DD(long ptr, M ddManager) {
        this.ptr = ptr;
        this.ddManager = ddManager;
    }

    public long ptr() {
        return this.ptr;
    }

    public long regularPtr() {
        return ((DDManager)this.ddManager).backend.regularPtr(this.ptr);
    }

    public M ddManager() {
        return this.ddManager;
    }

    public D withRef() {
        this.ref();
        return this.thisCasted();
    }

    public void ref() {
        ((DDManager)this.ddManager).incRefCount(this.ptr);
        ((DDManager)this.ddManager).backend.ref(this.ptr);
    }

    public void recursiveDeref() {
        ((DDManager)this.ddManager).decRefCount(this.ptr);
        ((DDManager)this.ddManager).backend.deref(((DDManager)this.ddManager).ptr(), this.ptr);
    }

    public int readIndex() {
        this.assertNonConstant();
        return ((DDManager)this.ddManager).backend.readIndex(this.ptr);
    }

    public int readPerm() {
        this.assertNonConstant();
        return ((DDManager)this.ddManager).backend.readPerm(((DDManager)this.ddManager()).ptr(), this.readIndex());
    }

    public String readName() {
        return ((DDManager)this.ddManager()).varName(this.readIndex());
    }

    public boolean isConstant() {
        return Conversions.asBoolean(((DDManager)this.ddManager).backend.isConstant(this.ptr));
    }

    public long dagSize() {
        return ((DDManager)this.ddManager).backend.dagSize(this.ptr);
    }

    protected abstract D thisCasted();

    public abstract D t();

    public abstract D e();

    public abstract D eval(boolean ... var1);

    protected void assertEqualDDManager(DD<?, ?> dd) {
        if (!this.ddManager.equals(dd.ddManager())) {
            throw new DDManagerException(this.getClass().getSimpleName() + " operands must share the same " + DDManager.class.getSimpleName());
        }
    }

    protected void assertEqualDDManager(DD<?, ?> ... dds) {
        for (DD<?, ?> dd : dds) {
            this.assertEqualDDManager(dd);
        }
    }

    protected void assertConstant() {
        if (!this.isConstant()) {
            throw new DDException("Expected constant " + this.getClass().getSimpleName());
        }
    }

    protected void assertNonConstant() {
        if (this.isConstant()) {
            throw new DDException("Expected non-constant " + this.getClass().getSimpleName());
        }
    }

    public boolean equals(@Nullable Object otherObj) {
        if (otherObj instanceof DD) {
            DD other = (DD)otherObj;
            return this.ptr == other.ptr;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.ptr);
    }

    public String toString() {
        if (this.isConstant()) {
            return "?";
        }
        return this.readName();
    }
}

