/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.latticedd.example;

import info.scce.addlib.backend.ADDBackend;
import info.scce.addlib.backend.BackendProvider;
import info.scce.addlib.dd.bdd.BDD;
import info.scce.addlib.dd.bdd.BDDManager;
import info.scce.addlib.dd.xdd.XDD;
import info.scce.addlib.dd.xdd.latticedd.BooleanLatticeDDManager;
import java.util.HashMap;
import java.util.Map;

public class BooleanLogicDDManager
extends BooleanLatticeDDManager<Boolean> {
    public BooleanLogicDDManager() {
        this(BackendProvider.getADDBackend());
    }

    public BooleanLogicDDManager(ADDBackend backend) {
        super(backend);
    }

    @Override
    protected Boolean meet(Boolean left, Boolean right) {
        return left != false && right != false;
    }

    @Override
    protected Boolean join(Boolean left, Boolean right) {
        return left != false || right != false;
    }

    @Override
    protected Boolean botElement() {
        return false;
    }

    @Override
    protected Boolean topElement() {
        return true;
    }

    @Override
    protected Boolean compl(Boolean x) {
        return x == false;
    }

    @Override
    public Boolean parseElement(String str) {
        return Boolean.parseBoolean(str);
    }

    public BDD toBDD(BDDManager ddManagerTarget, XDD<Boolean> sourceDD) {
        HashMap<XDD<Boolean>, BDD> cache = new HashMap<XDD<Boolean>, BDD>();
        BDD result = this.toBDDRecursive(ddManagerTarget, sourceDD, cache);
        cache.remove(sourceDD);
        for (BDD g2 : cache.values()) {
            g2.recursiveDeref();
        }
        return result;
    }

    private BDD toBDDRecursive(BDDManager ddManagerTarget, XDD<Boolean> sourceDD, Map<XDD<Boolean>, BDD> cache) {
        BDD result = cache.get(sourceDD);
        if (result == null) {
            if (sourceDD.isConstant()) {
                boolean value = sourceDD.v();
                result = value ? ddManagerTarget.readOne() : ddManagerTarget.readLogicZero();
            } else {
                String name = sourceDD.readName();
                int idx = ddManagerTarget.varIdx(name);
                BDD t = this.toBDDRecursive(ddManagerTarget, (XDD<Boolean>)sourceDD.t(), cache);
                BDD e = this.toBDDRecursive(ddManagerTarget, (XDD<Boolean>)sourceDD.e(), cache);
                BDD varIdx = ddManagerTarget.ithVar(idx);
                result = varIdx.ite(t, e);
                varIdx.recursiveDeref();
            }
            cache.put(sourceDD, result);
        }
        return result;
    }
}

