/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.layouter;

import info.scce.addlib.codegenerator.DotGenerator;
import info.scce.addlib.dd.LabelledRegularDD;
import info.scce.addlib.dd.RegularDD;
import info.scce.addlib.layouter.BoundingBox;
import info.scce.addlib.layouter.Layouter;
import info.scce.addlib.layouter.LayouterException;
import info.scce.addlib.traverser.PreorderTraverser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DotLayouter<D extends RegularDD<?, D>>
extends Layouter<D> {
    private static final String DOUBLE_REGEX = "[+-]?\\d*(\\.\\d+([eE][+-]?\\d+)?)?";
    private static final String NODE_REGEX = "node n(?<ptr>\\d+) (?<x>[+-]?\\d*(\\.\\d+([eE][+-]?\\d+)?)?) (?<y>[+-]?\\d*(\\.\\d+([eE][+-]?\\d+)?)?) (?<w>[+-]?\\d*(\\.\\d+([eE][+-]?\\d+)?)?) (?<h>[+-]?\\d*(\\.\\d+([eE][+-]?\\d+)?)?).*";
    private final DotGenerator<D> dotGenerator = new DotGenerator();
    private Pattern dotOutLinePattern;
    private Layouter<D> fallbackLayouter;

    public DotLayouter<D> withFallbackLayouter(Layouter<D> fallbackLayouter) {
        this.fallbackLayouter = fallbackLayouter;
        return this;
    }

    public static boolean isAvailable() {
        try {
            boolean executionSuccessful;
            Process process = new ProcessBuilder("dot", "-V").start();
            process.waitFor();
            int exitValue = process.exitValue();
            boolean bl = executionSuccessful = exitValue == 0;
            if (executionSuccessful) {
                return true;
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected Map<D, BoundingBox> computeLayout(List<D> roots) {
        if (DotLayouter.isAvailable()) {
            Map<D, BoundingBox> map;
            block10: {
                ProcessBuilder pb = new ProcessBuilder("dot", "-Tplain").redirectError(ProcessBuilder.Redirect.INHERIT);
                Process p = pb.start();
                this.dotGenerator.generate(p.getOutputStream(), this.withRandomLabels(roots));
                p.getOutputStream().close();
                InputStream in = p.getInputStream();
                try {
                    map = this.parseDotOut(in, this.ddByPtr(roots));
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                in.close();
            }
            return map;
        }
        if (this.fallbackLayouter == null) {
            throw new LayouterException("Could not layout with dot and fallback layouter was not set");
        }
        return this.fallbackLayouter.computeLayout(roots);
    }

    private List<LabelledRegularDD<D>> withRandomLabels(List<D> roots) {
        ArrayList<LabelledRegularDD<D>> labelled = new ArrayList<LabelledRegularDD<D>>();
        for (RegularDD r : roots) {
            labelled.add(new LabelledRegularDD<RegularDD>(r, "f"));
        }
        return labelled;
    }

    private Map<Long, D> ddByPtr(List<D> roots) {
        HashMap<Long, RegularDD> ddByPtr = new HashMap<Long, RegularDD>();
        for (RegularDD f : new PreorderTraverser<D>(roots)) {
            ddByPtr.put(f.ptr(), f);
        }
        return ddByPtr;
    }

    private Map<D, BoundingBox> parseDotOut(InputStream in, Map<Long, D> ddByPtr) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        HashMap<RegularDD, BoundingBox> layout = new HashMap<RegularDD, BoundingBox>();
        while ((line = reader.readLine()) != null) {
            Matcher m3 = this.dotOutLinePattern().matcher(line);
            if (!m3.matches()) continue;
            long ptr = Long.parseLong(this.captureMatcherGroup(m3, "ptr"));
            RegularDD dd = (RegularDD)ddByPtr.get(ptr);
            if (dd == null) {
                throw new IllegalArgumentException("The input contains pointers to unregistered DDs!");
            }
            double x = Double.parseDouble(this.captureMatcherGroup(m3, "x"));
            double y = Double.parseDouble(this.captureMatcherGroup(m3, "y"));
            double w = Double.parseDouble(this.captureMatcherGroup(m3, "w"));
            double h2 = Double.parseDouble(this.captureMatcherGroup(m3, "h"));
            layout.put(dd, new BoundingBox(x, y, w, h2));
        }
        return layout;
    }

    private String captureMatcherGroup(Matcher matcher, String groupName) {
        String capturedGroup = matcher.group(groupName);
        if (capturedGroup == null) {
            throw new NoSuchElementException(String.format("The matcher could not find the requested group '%s'!", groupName));
        }
        return capturedGroup;
    }

    private Pattern dotOutLinePattern() {
        if (this.dotOutLinePattern == null) {
            this.dotOutLinePattern = Pattern.compile(NODE_REGEX);
        }
        return this.dotOutLinePattern;
    }
}

