/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.layouter;

import info.scce.addlib.dd.RegularDD;
import info.scce.addlib.layouter.BoundingBox;
import info.scce.addlib.layouter.LayouterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Layouter<D extends RegularDD<?, D>> {
    private List<D> roots;
    private @Nullable Map<D, BoundingBox> layout;
    private @Nullable BoundingBox bbox;
    private double transformationFactorX = 1.0;
    private double transformationOffsetX = 0.0;
    private double transformationFactorY = 1.0;
    private double transformationOffsetY = 0.0;

    public void layout(D root) {
        this.layout(Collections.singletonList(root));
    }

    public void layout(List<D> roots) {
        this.roots = new ArrayList<D>(roots);
        this.layout = null;
        this.bbox = null;
    }

    public List<D> roots() {
        return new ArrayList<D>(this.roots);
    }

    public void setTransformationX(double factor, double offset) {
        this.transformationFactorX = factor;
        this.transformationOffsetX = offset;
    }

    public void setTransformationY(double factor, double offset) {
        this.transformationFactorY = factor;
        this.transformationOffsetY = offset;
    }

    public void setTransformation(double factorX, double offsetX, double factorY, double offsetY) {
        this.transformationFactorX = factorX;
        this.transformationOffsetX = offsetX;
        this.transformationFactorY = factorY;
        this.transformationOffsetY = offsetY;
    }

    public void setViewport(double w, double h2) {
        this.setViewport(0.0, 0.0, w, h2);
    }

    public void setViewport(double x, double y, double w, double h2) {
        BoundingBox bbox = this.internalBBox();
        double x0 = bbox.x();
        double y0 = bbox.y();
        double w0 = bbox.w();
        double h0 = bbox.h();
        this.transformationFactorX = w / w0;
        this.transformationOffsetX = x - x0 * w / w0;
        this.transformationFactorY = h2 / h0;
        this.transformationOffsetY = y - y0 * h2 / h0;
    }

    public double transformationFactorX() {
        return this.transformationFactorX;
    }

    public double transformationOffsetX() {
        return this.transformationOffsetX;
    }

    public double transformationFactorY() {
        return this.transformationFactorY;
    }

    public double transformationOffsetY() {
        return this.transformationOffsetY;
    }

    private double transformedX(double x, double w) {
        if (this.transformationFactorX >= 0.0) {
            return this.transformationFactorX * x + this.transformationOffsetX;
        }
        return this.transformationFactorX * x + this.transformationOffsetX - this.transformedW(w);
    }

    private double transformedY(double y, double h2) {
        if (this.transformationFactorY >= 0.0) {
            return this.transformationFactorY * y + this.transformationOffsetY;
        }
        return this.transformationFactorY * y + this.transformationOffsetY - this.transformedH(h2);
    }

    private double transformedW(double w) {
        return Math.abs(this.transformationFactorX) * w;
    }

    private double transformedH(double h2) {
        return Math.abs(this.transformationFactorY) * h2;
    }

    public double x(D f) {
        return this.transformedX(this.internalBBox(f).x(), this.internalBBox(f).w());
    }

    public double y(D f) {
        return this.transformedY(this.internalBBox(f).y(), this.internalBBox(f).h());
    }

    public double w(D f) {
        return this.transformedW(this.internalBBox(f).w());
    }

    public double h(D f) {
        return this.transformedH(this.internalBBox(f).h());
    }

    public BoundingBox bbox(D f) {
        return new BoundingBox(this.x(f), this.y(f), this.w(f), this.h(f));
    }

    private BoundingBox internalBBox(D f) {
        BoundingBox bbox = this.layout().get(f);
        if (bbox == null) {
            throw new LayouterException("Missing layout information for " + f.getClass().getSimpleName() + " (Invoke layout first)");
        }
        return bbox;
    }

    public double x() {
        return this.transformedX(this.internalBBox().x(), this.internalBBox().w());
    }

    public double y() {
        return this.transformedY(this.internalBBox().y(), this.internalBBox().h());
    }

    public double w() {
        return this.transformedW(this.internalBBox().w());
    }

    public double h() {
        return this.transformedH(this.internalBBox().h());
    }

    public BoundingBox bbox() {
        return new BoundingBox(this.x(), this.y(), this.w(), this.h());
    }

    private BoundingBox internalBBox() {
        if (this.bbox == null) {
            Map<D, BoundingBox> layout = this.layout();
            if (!layout.isEmpty()) {
                double minX = Double.MAX_VALUE;
                double minY = Double.MAX_VALUE;
                double maxX = Double.MIN_VALUE;
                double maxY = Double.MIN_VALUE;
                for (BoundingBox bbox : layout.values()) {
                    minX = Math.min(minX, bbox.x());
                    minY = Math.min(minY, bbox.y());
                    maxX = Math.max(maxX, bbox.x2());
                    maxY = Math.max(maxY, bbox.y2());
                }
                double x = minX;
                double y = minY;
                double w = maxX - minX;
                double h2 = maxY - minY;
                this.bbox = new BoundingBox(x, y, w, h2);
            } else {
                this.bbox = new BoundingBox(0.0, 0.0, 0.0, 0.0);
            }
        }
        return this.bbox;
    }

    private Map<D, BoundingBox> layout() {
        if (this.layout == null) {
            this.layout = this.computeLayout(this.roots);
        }
        return this.layout;
    }

    protected abstract Map<D, BoundingBox> computeLayout(List<D> var1);
}

