/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.nativelib;

import info.scce.addlib.nativelib.NativeDependencyError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Locale;

public final class NativeLibraryLoader {
    private NativeLibraryLoader() {
    }

    public static <T> void loadNativeLibrary(Class<T> clazz, String name) throws NativeDependencyError {
        File nativeLibTmpFile;
        String nativeLibResourceName = NativeLibraryLoader.nativeLibResourceName(name);
        try (InputStream nativeLibIStream = clazz.getResourceAsStream(nativeLibResourceName);){
            if (nativeLibIStream == null) {
                throw new NativeDependencyError("Missing resource '" + nativeLibResourceName + "'");
            }
            nativeLibTmpFile = NativeLibraryLoader.nativeLibTmpFile(name);
            try {
                Files.copy(nativeLibIStream, nativeLibTmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                nativeLibIStream.close();
            }
            catch (IOException e) {
                throw new NativeDependencyError("Failed to copy native library from resource '" + nativeLibResourceName + "' to temporary file '" + nativeLibTmpFile.toPath() + "'", e);
            }
        }
        catch (IOException e) {
            throw new NativeDependencyError("Failed to open resource.", e);
        }
        try {
            System.load(nativeLibTmpFile.getAbsolutePath());
        }
        catch (NullPointerException | SecurityException | UnsatisfiedLinkError e) {
            throw new NativeDependencyError("Failed to load library", e);
        }
    }

    private static String nativeLibResourceName(String nativeLibName) {
        OSFamily osFamily = NativeLibraryLoader.nativeLibOSFamily();
        OSArch osArch = NativeLibraryLoader.nativeLibOSArch();
        String filename = nativeLibName + osFamily.getFileExtension();
        String osPkg = osFamily.toString().toLowerCase(Locale.ROOT);
        String archPkg = osArch.toString().toLowerCase(Locale.ROOT);
        return "/nativelib/" + osPkg + "/" + archPkg + "/" + filename;
    }

    private static File nativeLibTmpFile(String nativeLibName) {
        OSFamily osFamily = NativeLibraryLoader.nativeLibOSFamily();
        try {
            File tempFile = File.createTempFile(nativeLibName, osFamily.getFileExtension());
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (IOException e) {
            throw new NativeDependencyError("Failed to create temporary file", e);
        }
    }

    private static OSFamily nativeLibOSFamily() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (osName.contains("linux")) {
            return OSFamily.LINUX;
        }
        if (osName.contains("mac")) {
            return OSFamily.MAC;
        }
        if (osName.contains("windows")) {
            return OSFamily.WINDOWS;
        }
        throw new NativeDependencyError("Unknown or unsupported OS family");
    }

    private static OSArch nativeLibOSArch() {
        String osArch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (osArch.contains("x86_64") || osArch.contains("amd64")) {
            return OSArch.X64;
        }
        throw new NativeDependencyError("Unknown or unsupported OS architecture");
    }

    private static enum OSArch {
        X64;

    }

    private static enum OSFamily {
        LINUX(".so"),
        MAC(".dylib"),
        WINDOWS(".dll");

        final String fileExt;

        private OSFamily(String fileExt) {
            this.fileExt = fileExt;
        }

        String getFileExtension() {
            return this.fileExt;
        }
    }
}

