/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.parser;

import info.scce.addlib.dd.bdd.BDD;
import info.scce.addlib.dd.bdd.BDDManager;
import info.scce.addlib.parser.BDDLanguageBaseVisitor;
import info.scce.addlib.parser.BDDLanguageParser;

public class BDDVisitor
extends BDDLanguageBaseVisitor<BDD> {
    private final BDDManager ddManager;

    public BDDVisitor(BDDManager ddManager) {
        this.ddManager = ddManager;
    }

    @Override
    public BDD visitNotExpr(BDDLanguageParser.NotExprContext ctx) {
        BDD child = (BDD)this.visit(ctx.ex);
        BDD result = child.not();
        child.recursiveDeref();
        return result;
    }

    @Override
    public BDD visitAtomExpr(BDDLanguageParser.AtomExprContext ctx) {
        return (BDD)this.visit(ctx.ap);
    }

    @Override
    public BDD visitOrExpr(BDDLanguageParser.OrExprContext ctx) {
        BDD left = (BDD)this.visit(ctx.left);
        BDD right = (BDD)this.visit(ctx.right);
        BDD result = left.or(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public BDD visitParenExpr(BDDLanguageParser.ParenExprContext ctx) {
        return (BDD)this.visit(ctx.ex);
    }

    @Override
    public BDD visitAndExpr(BDDLanguageParser.AndExprContext ctx) {
        BDD left = (BDD)this.visit(ctx.left);
        BDD right = (BDD)this.visit(ctx.right);
        BDD result = left.and(right);
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public BDD visitTrueExpr(BDDLanguageParser.TrueExprContext ctx) {
        return this.ddManager.readOne();
    }

    @Override
    public BDD visitFalseExpr(BDDLanguageParser.FalseExprContext ctx) {
        return this.ddManager.readLogicZero();
    }

    @Override
    public BDD visitVarExpr(BDDLanguageParser.VarExprContext ctx) {
        String varName = ctx.var.getText();
        return this.ddManager.namedVar(varName);
    }
}

