/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.base;

import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.ShrinkableDeterministic;
import net.automatalib.automaton.base.AbstractFastMutable;
import net.automatalib.automaton.base.AbstractFastState;
import net.automatalib.ts.powerset.DeterministicPowersetView;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractFastMutableDet<S extends AbstractFastState<T>, I, T, SP, TP>
extends AbstractFastMutable<S, I, T, SP, TP>
implements ShrinkableDeterministic<S, I, T, SP, TP> {
    private @Nullable S initialState;

    public AbstractFastMutableDet(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
    }

    @Override
    public void setTransition(S state, I input, @Nullable T transition) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        ((AbstractFastState)state).setTransitionObject(inputIdx, transition);
    }

    @Override
    public @Nullable S getInitialState() {
        return this.initialState;
    }

    @Override
    public void setInitialState(@Nullable S state) {
        this.initialState = state;
    }

    @Override
    public @Nullable T getTransition(S state, I input) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        return ((AbstractFastState)state).getTransitionObject(inputIdx);
    }

    @Override
    public void removeState(S state, @Nullable S replacement) {
        super.removeState(state, replacement);
        if (state.equals(this.initialState)) {
            this.initialState = replacement;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.initialState = null;
    }

    public DeterministicPowersetView<S, I, T> powersetView() {
        return new DeterministicPowersetView(this);
    }

    @Override
    public Collection<I> getLocalInputs(S state) {
        Alphabet alphabet = this.getInputAlphabet();
        int alphabetSize = alphabet.size();
        ArrayList result = new ArrayList(alphabetSize);
        for (int i = 0; i < alphabetSize; ++i) {
            if (((AbstractFastState)state).getTransitionObject(i) == null) continue;
            result.add(alphabet.getSymbol(i));
        }
        return result;
    }
}

