/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.procedural;

import java.util.Collection;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.concept.FiniteRepresentation;
import net.automatalib.automaton.concept.InputAlphabetHolder;
import net.automatalib.automaton.procedural.ProceduralGraphView;
import net.automatalib.graph.Graph;
import net.automatalib.graph.concept.GraphViewable;
import org.checkerframework.checker.nullness.qual.Nullable;

interface ProceduralSystem<I, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?>>
extends FiniteRepresentation,
GraphViewable,
InputAlphabetHolder<I> {
    @Override
    public ProceduralInputAlphabet<I> getInputAlphabet();

    default public Collection<I> getProceduralInputs() {
        return this.getProceduralInputs(this.getInputAlphabet());
    }

    public Collection<I> getProceduralInputs(Collection<I> var1);

    public @Nullable I getInitialProcedure();

    public Map<I, M> getProcedures();

    default public @Nullable M getProcedure(I callSymbol) {
        if (!1.$assertionsDisabled && !this.getInputAlphabet().isCallSymbol(callSymbol)) {
            throw new AssertionError();
        }
        return (M)((UniversalDeterministicAutomaton)this.getProcedures().get(callSymbol));
    }

    @Override
    default public int size() {
        int size = 0;
        for (UniversalDeterministicAutomaton p : this.getProcedures().values()) {
            size += p.size();
        }
        return size;
    }

    @Override
    default public Graph<?, ?> graphView() {
        Alphabet alphabet = this.getInputAlphabet();
        return new ProceduralGraphView(alphabet.getInternalAlphabet(), this.getProceduralInputs(alphabet), this.getProcedures());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

