/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.procedural;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StackState<S, I, P> {
    private static final StackState<?, ?, ?> INIT = new StackState();
    private static final StackState<?, ?, ?> SINK = new StackState();
    private static final StackState<?, ?, ?> TERM = new StackState();
    private final @Nullable StackState<S, I, P> prev;
    private final @Nullable P procedure;
    private final @Nullable S procedureState;

    private StackState() {
        this.prev = null;
        this.procedure = null;
        this.procedureState = null;
    }

    private StackState(StackState<S, I, P> prev, P procedure, S procedureState) {
        this.prev = prev;
        this.procedure = procedure;
        this.procedureState = procedureState;
    }

    StackState<S, I, P> push(P newProcedure, S newState) {
        return new StackState<S, I, P>(this, newProcedure, newState);
    }

    StackState<S, I, P> pop() {
        assert (!this.isStatic()) : "This method should never be called on static states";
        return this.prev;
    }

    StackState<S, I, P> updateState(S state) {
        assert (!this.isStatic()) : "This method should never be called on static states";
        return new StackState<S, I, P>(this.prev, this.procedure, state);
    }

    P getProcedure() {
        assert (!this.isStatic()) : "This method should never be called on static states";
        return this.procedure;
    }

    S getCurrentState() {
        assert (!this.isStatic()) : "This method should never be called on static states";
        return this.procedureState;
    }

    static <I, S, P> StackState<S, I, P> sink() {
        return SINK;
    }

    boolean isSink() {
        return this == SINK;
    }

    static <I, S, P> StackState<S, I, P> init() {
        return INIT;
    }

    boolean isInit() {
        return this == INIT;
    }

    static <I, S, P> StackState<S, I, P> term() {
        return TERM;
    }

    boolean isTerm() {
        return this == TERM;
    }

    @EnsuresNonNullIf(expression={"this.prev", "this.procedure", "this.procedureState"}, result=false)
    private boolean isStatic() {
        return this.isInit() || this.isTerm() || this.isSink();
    }
}

