/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.vpa;

import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.vpa.SEVPA;
import net.automatalib.automaton.vpa.StackContents;
import net.automatalib.automaton.vpa.State;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractSEVPA<L, I>
implements SEVPA<L, I> {
    protected final VPAlphabet<I> alphabet;

    public AbstractSEVPA(VPAlphabet<I> alphabet) {
        this.alphabet = alphabet;
    }

    @Override
    public VPAlphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public @Nullable State<L> getTransition(State<L> state, I input) {
        L loc = state.getLocation();
        VPAlphabet.SymbolType type = this.alphabet.getSymbolType(input);
        switch (type) {
            case CALL: {
                int newStackElem = this.encodeStackSym(loc, input);
                return new State(this.getModuleEntry(input), StackContents.push(newStackElem, state.getStackContents()));
            }
            case RETURN: {
                StackContents contents = state.getStackContents();
                if (contents == null) {
                    return null;
                }
                int stackElem = contents.peek();
                L succ = this.getReturnSuccessor(loc, input, stackElem);
                if (succ == null) {
                    return null;
                }
                return new State<L>(succ, contents.pop());
            }
            case INTERNAL: {
                L succ = this.getInternalSuccessor(loc, input);
                if (succ == null) {
                    return null;
                }
                return new State<L>(succ, state.getStackContents());
            }
        }
        throw new IllegalStateException("Unknown symbol type " + (Object)((Object)type));
    }

    @Override
    public int encodeStackSym(L srcLoc, I callSym) {
        return this.encodeStackSym(srcLoc, this.alphabet.getCallSymbolIndex(callSym));
    }

    @Override
    public int encodeStackSym(L srcLoc, int callSymIdx) {
        return this.alphabet.getNumCalls() * this.getLocationId(srcLoc) + callSymIdx;
    }

    @Override
    public int getNumStackSymbols() {
        return this.size() * this.alphabet.getNumCalls();
    }

    public L getStackLoc(int stackSym) {
        return this.getLocation(stackSym / this.alphabet.getNumCalls());
    }

    public I getCallSym(int stackSym) {
        return this.alphabet.getCallSymbol(stackSym % this.alphabet.getNumCalls());
    }
}

