/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.vpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.vpa.SEVPA;
import net.automatalib.graph.Graph;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SEVPAGraphView<L, I>
implements Graph<L, SevpaViewEdge<L, I>> {
    private final SEVPA<L, I> sevpa;
    private final VPAlphabet<I> alphabet;

    public SEVPAGraphView(SEVPA<L, I> sevpa) {
        this.sevpa = sevpa;
        this.alphabet = sevpa.getInputAlphabet();
    }

    @Override
    public Collection<L> getNodes() {
        return Collections.unmodifiableCollection(this.sevpa.getLocations());
    }

    @Override
    public Collection<SevpaViewEdge<L, I>> getOutgoingEdges(L location) {
        L succ;
        ArrayList<SevpaViewEdge<L, I>> result = new ArrayList<SevpaViewEdge<L, I>>();
        for (Object i : this.alphabet.getCallAlphabet()) {
            succ = this.sevpa.getModuleEntry(i);
            if (succ == null) continue;
            result.add(new SevpaViewEdge(i, succ));
        }
        for (Object i : this.alphabet.getInternalAlphabet()) {
            succ = this.sevpa.getInternalSuccessor(location, i);
            if (succ == null) continue;
            result.add(new SevpaViewEdge(i, succ));
        }
        for (Object i : this.alphabet.getReturnAlphabet()) {
            for (L loc : this.sevpa.getLocations()) {
                for (Object stackSymbol : this.alphabet.getCallAlphabet()) {
                    int sym = this.sevpa.encodeStackSym(loc, stackSymbol);
                    L succ2 = this.sevpa.getReturnSuccessor(location, i, sym);
                    if (succ2 == null) continue;
                    result.add(new SevpaViewEdge(i, succ2, this.sevpa.getLocationId(loc), stackSymbol));
                }
            }
        }
        return result;
    }

    @Override
    public L getTarget(SevpaViewEdge<L, I> edge) {
        return (L)edge.target;
    }

    @Override
    public VisualizationHelper<L, SevpaViewEdge<L, I>> getVisualizationHelper() {
        return new DefaultVisualizationHelper<L, SevpaViewEdge<L, I>>(){

            @Override
            protected Collection<L> initialNodes() {
                return Collections.singleton(SEVPAGraphView.this.sevpa.getInitialLocation());
            }

            @Override
            public boolean getNodeProperties(L node, Map<String, String> properties) {
                super.getNodeProperties(node, properties);
                if (SEVPAGraphView.this.sevpa.isAcceptingLocation(node)) {
                    properties.put("shape", "doublecircle");
                }
                properties.put("label", "L" + SEVPAGraphView.this.sevpa.getLocationId(node));
                return true;
            }

            @Override
            public boolean getEdgeProperties(L src, SevpaViewEdge<L, I> edge, L tgt, Map<String, String> properties) {
                super.getEdgeProperties(src, edge, tgt, properties);
                Object input = edge.input;
                if (SEVPAGraphView.this.alphabet.isReturnSymbol(input)) {
                    properties.put("label", input + "/(L" + edge.callLocId + ',' + edge.callSymbol + ')');
                } else {
                    properties.put("label", String.valueOf(input));
                }
                return true;
            }
        };
    }

    public static class SevpaViewEdge<S, I> {
        public final I input;
        public final S target;
        public final int callLocId;
        public final @Nullable I callSymbol;

        SevpaViewEdge(I internalAction, S target) {
            this(internalAction, target, -1, null);
        }

        SevpaViewEdge(I returnAction, S target, int callLocId, @Nullable I callSymbol) {
            this.input = returnAction;
            this.target = target;
            this.callLocId = callLocId;
            this.callSymbol = callSymbol;
        }
    }
}

