/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util;

import java.io.IOException;
import java.util.Objects;
import net.automatalib.common.util.string.AbstractPrintable;
import net.automatalib.common.util.string.StringUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Pair<T1, T2>
extends AbstractPrintable {
    private final T1 first;
    private final T2 second;

    private Pair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public T1 getFirst() {
        return this.first;
    }

    public T2 getSecond() {
        return this.second;
    }

    @Override
    public void print(Appendable a) throws IOException {
        a.append('(');
        StringUtil.appendObject(a, this.first);
        a.append(", ");
        StringUtil.appendObject(a, this.second);
        a.append(')');
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair that = (Pair)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.first);
        result = 31 * result + Objects.hashCode(this.second);
        return result;
    }
}

