/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.collection;

import java.util.AbstractSet;
import java.util.BitSet;
import net.automatalib.common.util.collection.BitSetIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PositiveIntSet
extends AbstractSet<Integer> {
    private final BitSet delegate;
    private final boolean immutable;

    public PositiveIntSet() {
        this(new BitSet(), false);
    }

    public PositiveIntSet(BitSet delegate) {
        this(delegate, true);
    }

    public PositiveIntSet(BitSet delegate, boolean immutable) {
        this.delegate = delegate;
        this.immutable = immutable;
    }

    @Override
    public int size() {
        return this.delegate.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        return this.containsInt((Integer)o);
    }

    public boolean containsInt(int integer) {
        return this.delegate.get(integer);
    }

    public BitSetIterator iterator() {
        return new BitSetIterator(this.delegate, this.immutable);
    }

    @Override
    public boolean add(Integer integer) {
        return this.addInt(integer);
    }

    public boolean addInt(int integer) {
        if (this.immutable) {
            throw new UnsupportedOperationException("This is a read-only set-view");
        }
        boolean containedBefore = this.delegate.get(integer);
        this.delegate.set(integer);
        return !containedBefore;
    }

    @Override
    public boolean remove(@Nullable Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        return this.removeInt((Integer)o);
    }

    public boolean removeInt(int integer) {
        if (this.immutable) {
            throw new UnsupportedOperationException("This is a read-only set-view");
        }
        boolean containedBefore = this.delegate.get(integer);
        this.delegate.clear(integer);
        return containedBefore;
    }

    @Override
    public void clear() {
        if (this.immutable) {
            throw new UnsupportedOperationException("This is a read-only set-view");
        }
        this.delegate.clear();
    }
}

