/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.nid;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import net.automatalib.common.smartcollection.ArrayWritable;
import net.automatalib.common.smartcollection.ResizingArrayStorage;
import net.automatalib.common.util.nid.IDChangeNotifier;
import net.automatalib.common.util.nid.MutableNumericID;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DynamicList<T extends MutableNumericID>
extends AbstractList<T>
implements ArrayWritable<T> {
    private final ResizingArrayStorage<T> storage;
    private int size;

    public DynamicList() {
        this.size = 0;
        this.storage = new ResizingArrayStorage<MutableNumericID>(MutableNumericID.class);
    }

    public DynamicList(List<? extends T> initial) {
        this.size = initial.size();
        this.storage = new ResizingArrayStorage<MutableNumericID>(MutableNumericID.class, this.size);
        int idx = 0;
        Iterator<T> iterator = initial.iterator();
        while (iterator.hasNext()) {
            MutableNumericID t;
            ((MutableNumericID[])this.storage.array)[idx] = t = (MutableNumericID)iterator.next();
            t.setId(idx);
            ++idx;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean remove(@Nullable Object elem) {
        return this.remove(elem, null);
    }

    public boolean remove(@Nullable Object elem, @Nullable IDChangeNotifier<T> tracker) {
        if (!(elem instanceof MutableNumericID)) {
            return false;
        }
        MutableNumericID idElem = (MutableNumericID)elem;
        int idx = idElem.getId();
        T myElem = this.safeGet(idx);
        if (elem != myElem) {
            return false;
        }
        MutableNumericID last = ((MutableNumericID[])this.storage.array)[--this.size];
        if (idx != this.size) {
            ((MutableNumericID[])this.storage.array)[idx] = last;
            last.setId(idx);
            if (tracker != null) {
                tracker.notifyListeners(last, idx, this.size);
            }
        }
        ((MutableNumericID[])this.storage.array)[this.size] = null;
        myElem.setId(-1);
        return true;
    }

    public T remove(int index, IDChangeNotifier<T> tracker) {
        Object elem = this.get(index);
        MutableNumericID last = ((MutableNumericID[])this.storage.array)[--this.size];
        if (index != this.size) {
            ((MutableNumericID[])this.storage.array)[index] = last;
            last.setId(index);
            if (tracker != null) {
                tracker.notifyListeners(last, index, this.size);
            }
        }
        ((MutableNumericID[])this.storage.array)[this.size] = null;
        elem.setId(-1);
        return (T)elem;
    }

    public @Nullable T safeGet(int index) {
        if (index < 0 || index >= this.size) {
            return null;
        }
        return (T)((MutableNumericID[])this.storage.array)[index];
    }

    @Override
    public boolean add(T elem) {
        this.storage.ensureCapacity(this.size + 1);
        ((MutableNumericID[])this.storage.array)[this.size] = elem;
        elem.setId(this.size);
        ++this.size;
        return true;
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + index);
        }
        return (T)((MutableNumericID[])this.storage.array)[index];
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            ((MutableNumericID[])this.storage.array)[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index;

            @Override
            public boolean hasNext() {
                return this.index < DynamicList.this.size;
            }

            @Override
            public T next() {
                return DynamicList.this.get(this.index++);
            }

            @Override
            public void remove() {
                DynamicList.this.remove(--this.index);
            }
        };
    }

    public void swap(int a, int b) {
        if (a == b) {
            return;
        }
        if (a < 0 || a >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + a);
        }
        if (b < 0 || b >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + b);
        }
        MutableNumericID tmp = ((MutableNumericID[])this.storage.array)[a];
        ((MutableNumericID[])this.storage.array)[a] = ((MutableNumericID[])this.storage.array)[b];
        ((MutableNumericID[])this.storage.array)[b] = tmp;
        ((MutableNumericID[])this.storage.array)[a].setId(a);
        ((MutableNumericID[])this.storage.array)[b].setId(b);
    }

    @Override
    public void writeToArray(int offset, @Nullable Object[] array, int tgtOfs, int num) {
        System.arraycopy(this.storage.array, offset, array, tgtOfs, num);
    }
}

