/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa;

import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.automaton.concept.InputAlphabetHolder;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;

public abstract class AbstractIncrementalDFABuilder<I>
implements IncrementalDFABuilder<I>,
InputAlphabetHolder<I> {
    protected final Alphabet<I> inputAlphabet;
    protected int alphabetSize;

    public AbstractIncrementalDFABuilder(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
        this.alphabetSize = inputAlphabet.size();
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (!this.inputAlphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.inputAlphabet).addSymbol(symbol);
        }
        this.alphabetSize = this.inputAlphabet.size();
    }
}

