/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.incremental.mealy.AdaptiveMealyBuilder;
import net.automatalib.incremental.mealy.tree.AbstractAlphabetBasedMealyTreeBuilder;
import net.automatalib.incremental.mealy.tree.Edge;
import net.automatalib.incremental.mealy.tree.Node;
import net.automatalib.util.graph.traversal.GraphTraversal;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AdaptiveMealyTreeBuilder<I, O>
extends AbstractAlphabetBasedMealyTreeBuilder<I, O>
implements AdaptiveMealyBuilder<I, O> {
    private final Map<Node<O>, Word<I>> nodeToQuery = new LinkedHashMap<Node<O>, Word<I>>();

    public AdaptiveMealyTreeBuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
    }

    @Override
    public boolean insert(Word<? extends I> input, Word<? extends O> outputWord) {
        Node<O> curr = (Node<O>)this.root;
        boolean hasOverwritten = false;
        for (int i = 0; i < input.length(); ++i) {
            I sym = input.getSymbol(i);
            O out = outputWord.getSymbol(i);
            Edge edge = this.getEdge(curr, sym);
            if (edge == null) {
                curr = this.insertNode(curr, sym, out);
                continue;
            }
            if (!Objects.equals(out, edge.getOutput())) {
                hasOverwritten = true;
                this.removeQueries(edge.getTarget());
                this.removeEdge(curr, sym);
                curr = this.insertNode(curr, sym, out);
                continue;
            }
            curr = edge.getTarget();
        }
        assert (curr != null);
        this.nodeToQuery.remove(curr);
        this.nodeToQuery.put(curr, Word.upcast(input));
        return hasOverwritten;
    }

    private void removeQueries(Node<O> node) {
        GraphTraversal.breadthFirstIterator(this.asGraph(), Collections.singleton(node)).forEachRemaining(this.nodeToQuery::remove);
    }

    private void removeEdge(Node<O> node, I symbol) {
        node.setEdge(this.getInputAlphabet().getSymbolIndex(symbol), null);
    }

    @Override
    public @Nullable Word<I> getOldestInput() {
        Iterator<Word<I>> iter = this.nodeToQuery.values().iterator();
        return iter.hasNext() ? iter.next() : null;
    }
}

