/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.tree;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.automatalib.graph.Graph;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.incremental.mealy.tree.AbstractMealyTreeBuilder;
import net.automatalib.incremental.mealy.tree.DynamicNode;
import net.automatalib.incremental.mealy.tree.Edge;
import net.automatalib.util.graph.traversal.GraphTraversal;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DynamicIncrementalMealyTreeBuilder<I, O>
extends AbstractMealyTreeBuilder<DynamicNode<I, O>, I, O>
implements IncrementalMealyBuilder<I, O> {
    public DynamicIncrementalMealyTreeBuilder() {
        super(new DynamicNode());
    }

    @Override
    public void insert(Word<? extends I> input, Word<? extends O> outputWord) {
        DynamicNode<I, O> curr = (DynamicNode<I, O>)this.root;
        for (int i = 0; i < input.length(); ++i) {
            I sym = input.getSymbol(i);
            O out = outputWord.getSymbol(i);
            Edge<DynamicNode<I, O>, O> edge = this.getEdge(curr, sym);
            if (edge == null) {
                curr = this.insertNode(curr, sym, out);
                continue;
            }
            if (!Objects.equals(out, edge.getOutput())) {
                throw new ConflictException();
            }
            curr = edge.getTarget();
        }
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
    }

    @Override
    @Nullable Edge<DynamicNode<I, O>, O> getEdge(DynamicNode<I, O> node, I symbol) {
        return node.getEdge(symbol);
    }

    @Override
    DynamicNode<I, O> createNode() {
        return new DynamicNode();
    }

    @Override
    DynamicNode<I, O> insertNode(DynamicNode<I, O> parent, I symbols, O output) {
        Object succ = this.createNode();
        Edge<Object, O> edge = new Edge<Object, O>(output, succ);
        parent.setEdge(symbols, edge);
        return succ;
    }

    @Override
    public Graph<?, ?> asGraph() {
        return new GraphView();
    }

    private class GraphView
    implements Graph<DynamicNode<I, O>, Map.Entry<I, Edge<DynamicNode<I, O>, O>>> {
        private GraphView() {
        }

        @Override
        public Collection<Map.Entry<I, Edge<DynamicNode<I, O>, O>>> getOutgoingEdges(DynamicNode<I, O> node) {
            return node.getOutEdges().entrySet();
        }

        @Override
        public DynamicNode<I, O> getTarget(Map.Entry<I, Edge<DynamicNode<I, O>, O>> edge) {
            return edge.getValue().getTarget();
        }

        @Override
        public Collection<DynamicNode<I, O>> getNodes() {
            ArrayList result = new ArrayList();
            Iterators.addAll(result, GraphTraversal.breadthFirstIterator(this, Collections.singleton((DynamicNode)DynamicIncrementalMealyTreeBuilder.this.root)));
            return result;
        }

        @Override
        public VisualizationHelper<DynamicNode<I, O>, Map.Entry<I, Edge<DynamicNode<I, O>, O>>> getVisualizationHelper() {
            return new DefaultVisualizationHelper<DynamicNode<I, O>, Map.Entry<I, Edge<DynamicNode<I, O>, O>>>(){
                private int id;

                @Override
                public boolean getNodeProperties(DynamicNode<I, O> node, Map<String, String> properties) {
                    super.getNodeProperties(node, properties);
                    properties.put("label", "n" + this.id++);
                    return true;
                }

                @Override
                public boolean getEdgeProperties(DynamicNode<I, O> src, Map.Entry<I, Edge<DynamicNode<I, O>, O>> edge, DynamicNode<I, O> tgt, Map<String, String> properties) {
                    super.getEdgeProperties(src, edge, tgt, properties);
                    properties.put("label", edge.getKey() + " / " + edge.getValue().getOutput());
                    return true;
                }

                @Override
                protected Collection<DynamicNode<I, O>> initialNodes() {
                    return Collections.singleton((DynamicNode)DynamicIncrementalMealyTreeBuilder.this.root);
                }
            };
        }
    }
}

