/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.solver;

import java.util.BitSet;
import net.automatalib.graph.ProceduralModalProcessGraph;
import net.automatalib.modelchecker.m3c.formula.DependencyGraph;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.solver.AbstractDDSolver;
import net.automatalib.modelchecker.m3c.transformer.AbstractPropertyTransformer;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WitnessTreeState<N, L, E, AP> {
    public final @Nullable WitnessTreeState<?, L, ?, AP> stack;
    public final AbstractDDSolver.WorkUnit<N, E> unit;
    public final L procedure;
    public final ProceduralModalProcessGraph<N, L, E, AP, ?> pmpg;
    public final N state;
    public final FormulaNode<L, AP> subformula;
    public final BitSet context;
    public final String displayLabel;
    public final @Nullable L edgeLabel;
    public final int parentId;
    public boolean isPartOfResult;

    WitnessTreeState(@Nullable WitnessTreeState<?, L, ?, AP> stack, AbstractDDSolver.WorkUnit<N, E> unit, N state, FormulaNode<L, AP> subformula, BitSet context, String displayLabel, @Nullable L edgeLabel, int parentId) {
        this.stack = stack;
        this.unit = unit;
        this.procedure = unit.label;
        this.pmpg = unit.pmpg;
        this.state = state;
        this.subformula = subformula;
        this.context = context;
        this.edgeLabel = edgeLabel;
        this.parentId = parentId;
        this.displayLabel = displayLabel;
        this.isPartOfResult = false;
    }

    BitSet getSatisfiedSubformulae(DependencyGraph<L, AP> dependencyGraph, N node) {
        return ((AbstractPropertyTransformer)this.unit.propTransformers.get(node)).evaluate(dependencyGraph.toBoolArray(this.context));
    }
}

