/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import net.automatalib.common.util.IOUtil;
import net.automatalib.graph.Graph;
import net.automatalib.serialization.ModelSerializer;
import net.automatalib.serialization.dot.GraphDOT;

public final class DOTSerializationProvider<N, E>
implements ModelSerializer<Graph<N, E>> {
    private static final DOTSerializationProvider<?, ?> INSTANCE = new DOTSerializationProvider();

    private DOTSerializationProvider() {
    }

    public static <N, E> DOTSerializationProvider<N, E> getInstance() {
        return INSTANCE;
    }

    @Override
    public void writeModel(OutputStream os, Graph<N, E> model) throws IOException {
        try (Writer w = IOUtil.asBufferedNonClosingUTF8Writer(os);){
            GraphDOT.write(model, (Appendable)w);
        }
    }
}

