/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.fsm.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractFSMParser<I> {
    public static final String NO_SUCH_STATE = "state with number %d is undefined";
    public static final String NON_DETERMINISM_DETECTED = "non-determinism detected (previous value: %s)";
    public static final String EXPECT_CHAR = "expected char '%c' not found";
    public static final String EXPECT_NUMBER = "number expected";
    public static final String EXPECT_IDENTIFIER = "expecting identifier";
    public static final String EXPECT_STRING = "expecting string";
    private final Function<String, I> inputParser;
    private int partLineNumber;
    private final Set<I> inputs = new HashSet<I>();
    protected final @Nullable Collection<? extends I> targetInputs;

    protected AbstractFSMParser(@Nullable Collection<? extends I> targetInputs, Function<String, I> inputParser) {
        this.inputParser = inputParser;
        this.targetInputs = targetInputs;
    }

    protected Function<String, I> getInputParser() {
        return this.inputParser;
    }

    protected int getPartLineNumber() {
        return this.partLineNumber;
    }

    protected StreamTokenizer getStreamTokenizer(Reader reader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(225, 160);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.quoteChar(34);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.ordinaryChar(40);
        streamTokenizer.ordinaryChar(41);
        return streamTokenizer;
    }

    protected Set<I> getInputs() {
        return this.inputs;
    }

    protected abstract void parseDataDefinition(StreamTokenizer var1) throws IOException;

    protected abstract void checkDataDefinitions(StreamTokenizer var1) throws IOException;

    protected abstract void parseStateVector(StreamTokenizer var1) throws IOException;

    protected abstract void checkStateVectors(StreamTokenizer var1) throws IOException;

    protected abstract void parseTransition(StreamTokenizer var1) throws IOException;

    protected abstract void checkTransitions(StreamTokenizer var1) throws IOException;

    protected void parse(Reader reader) throws IOException {
        Part part = Part.DATA_DEFINITION;
        this.partLineNumber = 0;
        StreamTokenizer streamTokenizer = this.getStreamTokenizer(reader);
        while (streamTokenizer.nextToken() != -1) {
            streamTokenizer.pushBack();
            switch (part) {
                case DATA_DEFINITION: {
                    if (streamTokenizer.nextToken() == -3 && "---".equals(streamTokenizer.sval)) {
                        part = Part.STATE_VECTORS;
                        this.partLineNumber = 0;
                        this.checkDataDefinitions(streamTokenizer);
                        break;
                    }
                    streamTokenizer.pushBack();
                    this.parseDataDefinition(streamTokenizer);
                    break;
                }
                case STATE_VECTORS: {
                    if (streamTokenizer.nextToken() == -3 && "---".equals(streamTokenizer.sval)) {
                        part = Part.TRANSITIONS;
                        this.partLineNumber = 0;
                        this.checkStateVectors(streamTokenizer);
                        break;
                    }
                    streamTokenizer.pushBack();
                    this.parseStateVector(streamTokenizer);
                    break;
                }
                case TRANSITIONS: {
                    this.parseTransition(streamTokenizer);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            while (streamTokenizer.nextToken() != 10) {
            }
            ++this.partLineNumber;
        }
        this.checkTransitions(streamTokenizer);
    }

    protected static enum Part {
        DATA_DEFINITION,
        STATE_VECTORS,
        TRANSITIONS;

    }
}

