/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graph.scc;

import java.util.List;
import net.automatalib.graph.Graph;
import net.automatalib.util.graph.scc.SCCCollector;
import net.automatalib.util.graph.scc.SCCListener;
import net.automatalib.util.graph.scc.TarjanSCCVisitor;
import net.automatalib.util.graph.traversal.GraphTraversal;

public final class SCCs {
    private SCCs() {
    }

    public static <N, E> List<List<N>> collectSCCs(Graph<N, E> graph) {
        SCCCollector coll = new SCCCollector();
        SCCs.findSCCs(graph, coll);
        return coll.getSCCList();
    }

    public static <N, E> void findSCCs(Graph<N, E> graph, SCCListener<N> listener) {
        TarjanSCCVisitor vis = new TarjanSCCVisitor(graph, listener);
        for (Object node : graph) {
            if (vis.hasVisited(node)) continue;
            GraphTraversal.depthFirst(graph, node, vis);
        }
    }
}

