/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.iterator;

import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.ts.TransitionSystem;

public final class DefinedInputsIterator<S, I>
extends AbstractIterator<I> {
    private final TransitionSystem<S, I, ?> ts;
    private final Iterator<? extends I> inputsIt;
    private final S state;

    public DefinedInputsIterator(TransitionSystem<S, I, ?> ts, S state, Iterator<? extends I> inputsIt) {
        this.ts = ts;
        this.inputsIt = inputsIt;
        this.state = state;
    }

    @Override
    protected I computeNext() {
        while (this.inputsIt.hasNext()) {
            I input = this.inputsIt.next();
            Collection<?> transitions = this.ts.getTransitions(this.state, input);
            if (transitions.isEmpty()) continue;
            return input;
        }
        return (I)this.endOfData();
    }
}

