/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CircleLayout<V, E>
extends AbstractLayout<V, E> {
    private double radius;
    private List<V> vertex_ordered_list;
    protected LoadingCache<V, CircleVertexData> circleVertexDatas = CacheBuilder.newBuilder().build(new CacheLoader<V, CircleVertexData>(){

        @Override
        public CircleVertexData load(V vertex) {
            return new CircleVertexData();
        }
    });

    public CircleLayout(Graph<V, E> g2) {
        super(g2);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setVertexOrder(Comparator<V> comparator) {
        if (this.vertex_ordered_list == null) {
            this.vertex_ordered_list = new ArrayList(this.getGraph().getVertices());
        }
        Collections.sort(this.vertex_ordered_list, comparator);
    }

    public void setVertexOrder(List<V> vertex_list) {
        if (!vertex_list.containsAll(this.getGraph().getVertices())) {
            throw new IllegalArgumentException("Supplied list must include all vertices of the graph");
        }
        this.vertex_ordered_list = vertex_list;
    }

    @Override
    public void reset() {
        this.initialize();
    }

    @Override
    public void initialize() {
        Dimension d = this.getSize();
        if (d != null) {
            if (this.vertex_ordered_list == null) {
                this.setVertexOrder(new ArrayList(this.getGraph().getVertices()));
            }
            double height = d.getHeight();
            double width = d.getWidth();
            if (this.radius <= 0.0) {
                this.radius = 0.45 * (height < width ? height : width);
            }
            int i = 0;
            for (V v : this.vertex_ordered_list) {
                Object coord = this.apply((Object)v);
                double angle = Math.PI * 2 * (double)i / (double)this.vertex_ordered_list.size();
                ((Point2D)coord).setLocation(Math.cos(angle) * this.radius + width / 2.0, Math.sin(angle) * this.radius + height / 2.0);
                CircleVertexData data = this.getCircleData(v);
                data.setAngle(angle);
                ++i;
            }
        }
    }

    protected CircleVertexData getCircleData(V v) {
        return this.circleVertexDatas.getUnchecked(v);
    }

    protected static class CircleVertexData {
        private double angle;

        protected CircleVertexData() {
        }

        protected double getAngle() {
            return this.angle;
        }

        protected void setAngle(double angle) {
            this.angle = angle;
        }

        public String toString() {
            return "CircleVertexData: angle=" + this.angle;
        }
    }
}

