/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.HashSet;

public class PrimMinimumSpanningTree<V, E>
implements Function<Graph<V, E>, Graph<V, E>> {
    protected Supplier<? extends Graph<V, E>> treeFactory;
    protected Function<? super E, Double> weights;

    public PrimMinimumSpanningTree(Supplier<? extends Graph<V, E>> supplier) {
        this(supplier, Functions.constant(1.0));
    }

    public PrimMinimumSpanningTree(Supplier<? extends Graph<V, E>> supplier, Function<? super E, Double> weights) {
        this.treeFactory = supplier;
        if (weights != null) {
            this.weights = weights;
        }
    }

    @Override
    public Graph<V, E> apply(Graph<V, E> graph) {
        HashSet unfinishedEdges = new HashSet(graph.getEdges());
        Graph tree = this.treeFactory.get();
        V root = this.findRoot(graph);
        if (graph.getVertices().contains(root)) {
            tree.addVertex(root);
        } else if (graph.getVertexCount() > 0) {
            tree.addVertex(graph.getVertices().iterator().next());
        }
        this.updateTree(tree, graph, unfinishedEdges);
        return tree;
    }

    protected V findRoot(Graph<V, E> graph) {
        for (Object v : graph.getVertices()) {
            if (graph.getInEdges(v).size() != 0) continue;
            return v;
        }
        if (graph.getVertexCount() > 0) {
            return graph.getVertices().iterator().next();
        }
        return null;
    }

    protected void updateTree(Graph<V, E> tree, Graph<V, E> graph, Collection<E> unfinishedEdges) {
        Collection tv = tree.getVertices();
        double minCost = Double.MAX_VALUE;
        Object nextEdge = null;
        Object nextVertex = null;
        Object currentVertex = null;
        for (Object object : unfinishedEdges) {
            if (tree.getEdges().contains(object)) continue;
            Pair<V> endpoints = graph.getEndpoints(object);
            V first = endpoints.getFirst();
            V second = endpoints.getSecond();
            if (tv.contains(first) && !tv.contains(second)) {
                if (!(this.weights.apply(object) < minCost)) continue;
                minCost = this.weights.apply(object);
                nextEdge = object;
                currentVertex = first;
                nextVertex = second;
                continue;
            }
            if (!tv.contains(second) || tv.contains(first) || !(this.weights.apply(object) < minCost)) continue;
            minCost = this.weights.apply(object);
            nextEdge = object;
            currentVertex = second;
            nextVertex = first;
        }
        if (nextVertex != null && nextEdge != null) {
            unfinishedEdges.remove(nextEdge);
            tree.addEdge(nextEdge, currentVertex, nextVertex);
            this.updateTree(tree, graph, unfinishedEdges);
        }
    }
}

