/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.layout.LayoutChangeListener;
import edu.uci.ics.jung.visualization.layout.LayoutEvent;
import edu.uci.ics.jung.visualization.layout.LayoutEventSupport;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CachingEdgeRenderer<V, E>
extends BasicEdgeRenderer<V, E>
implements ChangeListener,
LayoutChangeListener<V, E> {
    protected Map<E, Shape> edgeShapeMap = new HashMap<E, Shape>();
    protected Set<E> dirtyEdges = new HashSet();

    public CachingEdgeRenderer(BasicVisualizationServer<V, E> vv) {
        vv.getRenderContext().getMultiLayerTransformer().addChangeListener(this);
        Layout<V, E> layout = vv.getGraphLayout();
        if (layout instanceof LayoutEventSupport) {
            ((LayoutEventSupport)((Object)layout)).addLayoutChangeListener(this);
        }
    }

    @Override
    protected void drawSimpleEdge(RenderContext<V, E> rc, Layout<V, E> layout, E e) {
        MutableTransformer vt;
        int[] coords = new int[4];
        boolean[] loop = new boolean[1];
        Shape edgeShape = this.edgeShapeMap.get(e);
        if (edgeShape == null || this.dirtyEdges.contains(e)) {
            edgeShape = this.prepareFinalEdgeShape(rc, layout, e, coords, loop);
            this.edgeShapeMap.put(e, edgeShape);
            this.dirtyEdges.remove(e);
        }
        int x1 = coords[0];
        int y1 = coords[1];
        int x2 = coords[2];
        int y2 = coords[3];
        boolean isLoop = loop[0];
        GraphicsDecorator g2 = rc.getGraphicsContext();
        Graph<V, E> graph = layout.getGraph();
        boolean edgeHit = true;
        boolean arrowHit = true;
        Rectangle deviceRectangle = null;
        JComponent vv = rc.getScreenDevice();
        if (vv != null) {
            Dimension d = vv.getSize();
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        if ((vt = rc.getMultiLayerTransformer().getTransformer(Layer.VIEW)) instanceof LensTransformer) {
            vt = ((LensTransformer)vt).getDelegate();
        }
        if (edgeHit = vt.transform(edgeShape).intersects(deviceRectangle)) {
            Paint draw_paint;
            Paint oldPaint = g2.getPaint();
            Paint fill_paint = rc.getEdgeFillPaintTransformer().apply(e);
            if (fill_paint != null) {
                g2.setPaint(fill_paint);
                g2.fill(edgeShape);
            }
            if ((draw_paint = rc.getEdgeDrawPaintTransformer().apply(e)) != null) {
                g2.setPaint(draw_paint);
                g2.draw(edgeShape);
            }
            float scalex = (float)g2.getTransform().getScaleX();
            float scaley = (float)g2.getTransform().getScaleY();
            if ((double)scalex < 0.3 || (double)scaley < 0.3) {
                return;
            }
            if (rc.getEdgeArrowPredicate().apply(Context.getInstance(graph, e))) {
                Stroke new_stroke = rc.getEdgeArrowStrokeTransformer().apply(e);
                Stroke old_stroke = g2.getStroke();
                if (new_stroke != null) {
                    g2.setStroke(new_stroke);
                }
                Shape destVertexShape = rc.getVertexShapeTransformer().apply(graph.getEndpoints(e).getSecond());
                AffineTransform xf = AffineTransform.getTranslateInstance(x2, y2);
                destVertexShape = xf.createTransformedShape(destVertexShape);
                arrowHit = rc.getMultiLayerTransformer().getTransformer(Layer.VIEW).transform(destVertexShape).intersects(deviceRectangle);
                if (arrowHit) {
                    AffineTransform at = this.edgeArrowRenderingSupport.getArrowTransform(rc, edgeShape, destVertexShape);
                    if (at == null) {
                        return;
                    }
                    Shape arrow = rc.getEdgeArrowTransformer().apply(Context.getInstance(graph, e));
                    arrow = at.createTransformedShape(arrow);
                    g2.setPaint(rc.getArrowFillPaintTransformer().apply(e));
                    g2.fill(arrow);
                    g2.setPaint(rc.getArrowDrawPaintTransformer().apply(e));
                    g2.draw(arrow);
                }
                if (graph.getEdgeType(e) == EdgeType.UNDIRECTED) {
                    Shape vertexShape = rc.getVertexShapeTransformer().apply(graph.getEndpoints(e).getFirst());
                    xf = AffineTransform.getTranslateInstance(x1, y1);
                    vertexShape = xf.createTransformedShape(vertexShape);
                    arrowHit = rc.getMultiLayerTransformer().getTransformer(Layer.VIEW).transform(vertexShape).intersects(deviceRectangle);
                    if (arrowHit) {
                        AffineTransform at = this.edgeArrowRenderingSupport.getReverseArrowTransform(rc, edgeShape, vertexShape, !isLoop);
                        if (at == null) {
                            return;
                        }
                        Shape arrow = rc.getEdgeArrowTransformer().apply(Context.getInstance(graph, e));
                        arrow = at.createTransformedShape(arrow);
                        g2.setPaint(rc.getArrowFillPaintTransformer().apply(e));
                        g2.fill(arrow);
                        g2.setPaint(rc.getArrowDrawPaintTransformer().apply(e));
                        g2.draw(arrow);
                    }
                }
                if (new_stroke != null) {
                    g2.setStroke(old_stroke);
                }
            }
            g2.setPaint(oldPaint);
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        System.err.println("got change event " + evt);
        this.edgeShapeMap.clear();
    }

    @Override
    public void layoutChanged(LayoutEvent<V, E> evt) {
        V v = evt.getVertex();
        Graph<V, E> graph = evt.getGraph();
        this.dirtyEdges.addAll(graph.getIncidentEdges(v));
    }
}

