/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.ringlikedd.example;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ComplexNumber {
    private final double real;
    private final double imaginary;

    public ComplexNumber(double realPart, double imaginaryPart) {
        this.real = realPart;
        this.imaginary = imaginaryPart;
    }

    public double abs() {
        return Math.sqrt(this.real * this.real + this.imaginary * this.imaginary);
    }

    public double theta() {
        return Math.atan(this.imaginary / this.real);
    }

    public double getRealPart() {
        return this.real;
    }

    public double getImaginaryPart() {
        return this.imaginary;
    }

    public String toString() {
        return String.format("%f+%f i", this.real, this.imaginary);
    }

    public boolean equals(ComplexNumber other, double eps) {
        return Math.abs(this.real - other.real) < eps && Math.abs(this.imaginary - other.imaginary) < eps;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexNumber that = (ComplexNumber)o;
        return Double.compare(that.real, this.real) == 0 && Double.compare(that.imaginary, this.imaginary) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.real, this.imaginary);
    }
}

