/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.zdd;

import info.scce.addlib.backend.BackendProvider;
import info.scce.addlib.backend.ZDDBackend;
import info.scce.addlib.dd.DDManager;
import info.scce.addlib.dd.DDManagerException;
import info.scce.addlib.dd.DDReorderingType;
import info.scce.addlib.dd.zdd.ZDD;
import info.scce.addlib.parser.ZDDLanguageLexer;
import info.scce.addlib.parser.ZDDLanguageParser;
import info.scce.addlib.parser.ZDDVisitor;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;

public class ZDDManager
extends DDManager<ZDD, ZDDBackend> {
    public ZDDManager() {
        this(BackendProvider.getZDDBackend());
    }

    public ZDDManager(ZDDBackend backend) {
        super(backend);
    }

    @Override
    public boolean reduceHeap(DDReorderingType heuristic, int minsize) {
        if (!heuristic.isZDDReorderingType()) {
            throw new DDManagerException("Unsupported reordering heuristic for ZDD");
        }
        return ((ZDDBackend)this.backend).reorder(this.ptr, heuristic, minsize) != 0;
    }

    @Override
    public boolean setVariableOrder(int[] permutation) {
        return ((ZDDBackend)this.backend).setVariableOrder(this.ptr, permutation);
    }

    @Override
    public void enableAutomaticReordering(DDReorderingType heuristic) {
        if (!heuristic.isZDDReorderingType()) {
            throw new DDManagerException("Unsupported reordering heuristic for ZDD");
        }
        ((ZDDBackend)this.backend).enableAutomaticReordering(this.ptr, heuristic);
    }

    @Override
    public void disableAutomaticReordering() {
        ((ZDDBackend)this.backend).disableAutomaticReordering(this.ptr);
    }

    public ZDD readOne() {
        long ddNodePtr = ((ZDDBackend)this.backend).readOne(this.ptr);
        return (ZDD)new ZDD(ddNodePtr, this).withRef();
    }

    public ZDD readZddOne(int i) {
        long ddNodePtr = ((ZDDBackend)this.backend).readZddOne(this.ptr, i);
        return (ZDD)new ZDD(ddNodePtr, this).withRef();
    }

    public ZDD readZero() {
        long ddNodePtr = ((ZDDBackend)this.backend).readZero(this.ptr);
        return (ZDD)new ZDD(ddNodePtr, this).withRef();
    }

    @Override
    public int readPerm(int i) {
        return ((ZDDBackend)this.backend).readPerm(this.ptr, i);
    }

    @Override
    public ZDD namedVar(String name) {
        int i = this.varIdx(name);
        return this.backendIthVar(i);
    }

    @Override
    public ZDD ithVar(int i) {
        this.varName(i);
        return this.backendIthVar(i);
    }

    public ZDD namedIthVar(String name, int i) {
        this.addVarName(name, i);
        return this.ithVar(i);
    }

    private ZDD backendIthVar(int i) {
        long ddNodePtr = ((ZDDBackend)this.backend).ithVar(this.ptr, i);
        return (ZDD)new ZDD(ddNodePtr, this).withRef();
    }

    @Override
    public ZDD parse(String zddAsString) {
        ANTLRInputStream inputStream = new ANTLRInputStream(zddAsString);
        ZDDLanguageLexer lexer = new ZDDLanguageLexer(inputStream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ZDDLanguageParser parser = new ZDDLanguageParser(tokens);
        ZDDVisitor ast = new ZDDVisitor(this);
        return (ZDD)ast.visit(parser.start());
    }
}

