/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.layouter;

import info.scce.addlib.dd.DD;
import info.scce.addlib.dd.RegularDD;
import info.scce.addlib.layouter.BoundingBox;
import info.scce.addlib.layouter.Layouter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleLayouter<D extends RegularDD<?, D>>
extends Layouter<D> {
    private double anchorX = 0.0;
    private double anchorY = 0.0;
    private double nodeMarginX = 1.0;
    private double nodeMarginY = 1.0;
    private double nodeWidth = 0.5;
    private double nodeHeight = 0.5;
    private double nodeWidthPerCharacter = 0.0;

    public SimpleLayouter<D> withAnchorPosition(double anchorX, double anchorY) {
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        return this;
    }

    public SimpleLayouter<D> withNodeMargin(double nodeMarginX, double nodeMarginY) {
        this.nodeMarginX = nodeMarginX;
        this.nodeMarginY = nodeMarginY;
        return this;
    }

    public SimpleLayouter<D> withNodeDimension(double nodeWidth, double nodeHeight, double widthPerCharacter) {
        this.nodeWidth = nodeWidth;
        this.nodeHeight = nodeHeight;
        this.nodeWidthPerCharacter = widthPerCharacter;
        return this;
    }

    @Override
    protected Map<D, BoundingBox> computeLayout(List<D> roots) {
        List<List<D>> sortedLayers = this.sortedLayers(roots);
        return this.computeLayoutFromSortedList(sortedLayers);
    }

    private List<List<D>> sortedLayers(List<D> roots) {
        ArrayList<List<D>> sortedLayers = new ArrayList<List<D>>();
        ArrayList constants = new ArrayList();
        HashSet seen = new HashSet();
        for (RegularDD dd : roots) {
            this.sortedLayersRecur(dd, sortedLayers, constants, seen);
        }
        sortedLayers.add(constants);
        return sortedLayers;
    }

    private void sortedLayersRecur(D dd, List<List<D>> sortedLayers, List<D> constants, Set<D> seen) {
        if (!seen.contains(dd)) {
            seen.add(dd);
            if (((DD)dd).isConstant()) {
                constants.add(dd);
            } else {
                int i = ((DD)dd).readIndex();
                while (sortedLayers.size() <= i) {
                    sortedLayers.add(new ArrayList());
                }
                sortedLayers.get(i).add(dd);
                this.sortedLayersRecur((RegularDD)((DD)dd).t(), sortedLayers, constants, seen);
                this.sortedLayersRecur((RegularDD)((DD)dd).e(), sortedLayers, constants, seen);
            }
        }
    }

    private Map<D, BoundingBox> computeLayoutFromSortedList(List<List<D>> sortedLayers) {
        HashMap<RegularDD, BoundingBox> layout = new HashMap<RegularDD, BoundingBox>();
        double maxLayerWidth = this.maxLayerWidth(sortedLayers);
        double y = this.anchorY;
        for (List<D> layer : sortedLayers) {
            double x = this.layerX(layer, maxLayerWidth);
            for (RegularDD node : layer) {
                double nodeWidth = this.nodeWidth(node);
                layout.put(node, new BoundingBox(x, y, nodeWidth, this.nodeHeight));
                x += nodeWidth + this.nodeMarginX;
            }
            if (layer.isEmpty()) continue;
            y += this.nodeHeight + this.nodeMarginY;
        }
        return layout;
    }

    private double maxLayerWidth(List<List<D>> sortedLayers) {
        double maxLayerWidth = 0.0;
        for (List<D> layer : sortedLayers) {
            maxLayerWidth = Math.max(maxLayerWidth, this.layerWidth(layer));
        }
        return maxLayerWidth;
    }

    private double layerWidth(List<D> layer) {
        double width = 0.0;
        Iterator<D> it = layer.iterator();
        if (it.hasNext()) {
            width += this.nodeWidth((RegularDD)it.next());
        }
        while (it.hasNext()) {
            width += this.nodeMarginX + this.nodeWidth((RegularDD)it.next());
        }
        return width;
    }

    private double layerX(List<D> layer, double maxLayerWidth) {
        double smallestLayerX = this.anchorX - maxLayerWidth / 2.0;
        return smallestLayerX + (maxLayerWidth - this.layerWidth(layer)) / 2.0;
    }

    private double nodeWidth(D dd) {
        return this.nodeWidth + (double)((DD)dd).toString().length() * this.nodeWidthPerCharacter;
    }
}

