/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.parser;

import info.scce.addlib.dd.add.ADD;
import info.scce.addlib.dd.add.ADDManager;
import info.scce.addlib.parser.ADDLanguageBaseVisitor;
import info.scce.addlib.parser.ADDLanguageParser;

public class ADDVisitor
extends ADDLanguageBaseVisitor<ADD> {
    private final ADDManager ddManager;

    public ADDVisitor(ADDManager ddManager) {
        this.ddManager = ddManager;
    }

    @Override
    public ADD visitVarExpr(ADDLanguageParser.VarExprContext ctx) {
        String varName = ctx.var.getText();
        return this.ddManager.namedVar(varName);
    }

    @Override
    public ADD visitRealExpr(ADDLanguageParser.RealExprContext ctx) {
        double value = Double.parseDouble(ctx.real.getText());
        return this.ddManager.constant(value);
    }

    @Override
    public ADD visitPlusMinusExpr(ADDLanguageParser.PlusMinusExprContext ctx) {
        ADD result;
        ADD left = (ADD)this.visit(ctx.left);
        ADD right = (ADD)this.visit(ctx.right);
        char op = ctx.op.getText().charAt(0);
        if (op == '+') {
            result = left.plus(right);
        } else if (op == '-') {
            result = left.minus(right);
        } else {
            throw new IllegalArgumentException("unexpected operator '" + op + "'");
        }
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public ADD visitMulDivExpr(ADDLanguageParser.MulDivExprContext ctx) {
        ADD result;
        ADD left = (ADD)this.visit(ctx.left);
        ADD right = (ADD)this.visit(ctx.right);
        char op = ctx.op.getText().charAt(0);
        if (op == '*') {
            result = left.times(right);
        } else if (op == '/') {
            result = left.divide(right);
        } else {
            throw new IllegalArgumentException("unexpected operator '" + op + "'");
        }
        left.recursiveDeref();
        right.recursiveDeref();
        return result;
    }

    @Override
    public ADD visitParenExpr(ADDLanguageParser.ParenExprContext ctx) {
        return (ADD)this.visit(ctx.ex);
    }
}

