/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.viewer;

import info.scce.addlib.codegenerator.DotGenerator;
import info.scce.addlib.dd.LabelledRegularDD;
import info.scce.addlib.dd.RegularDD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DotViewerFrame<D extends RegularDD<?, D>>
extends JFrame {
    public static final int DEFAULT_CANVAS_WIDTH = 1024;
    public static final int DEFAULT_CANVAS_HEIGHT = 512;
    public static final String FILE_EXTENSION_DOT = "dot";
    public static final String FILE_EXTENSION_PNG = "png";
    public static final double ZOOM_BASE = 1.2;
    public static final Color ERROR_CIRCLES_COLOR = new Color(255, 0, 0, 64);
    public static final int ERROR_CIRCLES_N = 8;
    public static final int ERROR_LINE_HEIGHT = 16;
    public static final String ERROR_MESSAGE_L0 = "Failed to execute dot command";
    public static final String ERROR_MESSAGE_L1 = "https://www.graphviz.org/";
    private final JScrollPane scrollPane;
    private List<LabelledRegularDD<D>> roots;
    private BufferedImage image;
    private double zoomExp;

    public DotViewerFrame(String title) {
        super(title);
        this.setDefaultCloseOperation(2);
        JMenuItem exportPngItem = new JMenuItem("Export as *.png");
        exportPngItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        exportPngItem.addActionListener(this::onExportPng);
        JMenuItem exportDotItem = new JMenuItem("Export as *.dot");
        exportDotItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        exportDotItem.addActionListener(this::onExportDot);
        JMenuItem zoomInItem = new JMenuItem("Zoom in");
        zoomInItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        zoomInItem.addActionListener(e -> {
            this.zoomExp += 1.0;
            this.updateCanvas();
        });
        JMenuItem zoomOutItem = new JMenuItem("Zoom out");
        zoomOutItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        zoomOutItem.addActionListener(e -> {
            this.zoomExp -= 1.0;
            this.updateCanvas();
        });
        JMenu menu = new JMenu("Menu");
        menu.add(exportDotItem);
        menu.add(exportPngItem);
        menu.add(zoomInItem);
        menu.add(zoomOutItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        menuBar.setBorder(BorderFactory.createEmptyBorder());
        JLabel label = new JLabel();
        label.setHorizontalAlignment(0);
        this.scrollPane = new JScrollPane(label);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.setPreferredSize(new Dimension(1024, 512));
        this.getContentPane().add((Component)menuBar, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
    }

    public void view(List<LabelledRegularDD<D>> roots) {
        this.roots = new ArrayList<LabelledRegularDD<D>>(roots);
        this.image = this.createImage(roots);
        this.updateCanvas();
    }

    public BufferedImage createImage(List<LabelledRegularDD<D>> roots) {
        BufferedImage bufferedImage;
        block8: {
            ProcessBuilder pb = new ProcessBuilder(FILE_EXTENSION_DOT, "-Tpng").redirectError(ProcessBuilder.Redirect.INHERIT);
            Process p = pb.start();
            DotGenerator<D> g2 = new DotGenerator<D>();
            g2.generate(p.getOutputStream(), roots);
            p.getOutputStream().close();
            InputStream in = p.getInputStream();
            try {
                bufferedImage = ImageIO.read(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return this.createErrorImage();
                }
            }
            in.close();
        }
        return bufferedImage;
    }

    private BufferedImage createErrorImage() {
        BufferedImage img = new BufferedImage(1024, 512, 1);
        Graphics g2 = img.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, 1024, 512);
        g2.setColor(ERROR_CIRCLES_COLOR);
        for (int i = 1; i <= 8; ++i) {
            int d = Math.min(1024, 512) / 8 * i;
            int x = (int)(Math.random() * (double)(1024 - d));
            int y = (int)(Math.random() * (double)(512 - d));
            g2.fillOval(x, y, d, d);
        }
        g2.setColor(Color.BLACK);
        g2.setFont(new Font(g2.getFont().getName(), g2.getFont().getStyle(), 16));
        int y = 240;
        g2.drawString(ERROR_MESSAGE_L0, 16, y);
        g2.drawString(ERROR_MESSAGE_L1, 16, y += 16);
        return img;
    }

    private void updateCanvas(@UnknownInitialization DotViewerFrame<D> this) {
        double zoomFactor = Math.pow(1.2, this.zoomExp);
        int width = (int)((double)this.image.getWidth() * zoomFactor);
        int height = (int)((double)this.image.getHeight() * zoomFactor);
        Image scaledImage = this.image.getScaledInstance(width, height, 4);
        JViewport viewport = this.scrollPane.getViewport();
        this.scrollPane.setViewportView(new JLabel(new ImageIcon(scaledImage)));
        this.scrollPane.setViewport(viewport);
    }

    private void onExportDot(ActionEvent e) {
        File targetFile = this.promptTargetFile(FILE_EXTENSION_DOT);
        if (targetFile != null) {
            DotGenerator<D> g2 = new DotGenerator<D>();
            try {
                g2.generateToFileSystem(targetFile, this.roots);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onExportPng(ActionEvent e) {
        File targetFile = this.promptTargetFile(FILE_EXTENSION_PNG);
        if (targetFile != null) {
            try {
                ImageIO.write((RenderedImage)this.image, FILE_EXTENSION_PNG, targetFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private @Nullable File promptTargetFile(String ensureExt) {
        File targetFile;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        if (chooser.showSaveDialog(this) == 0 && (targetFile = chooser.getSelectedFile()) != null) {
            boolean validExt = targetFile.getName().toLowerCase(Locale.ROOT).endsWith(ensureExt.toLowerCase(Locale.ROOT));
            if (!validExt) {
                File parent = targetFile.getParentFile();
                String extendedName = targetFile.getName() + "." + ensureExt;
                targetFile = new File(parent, extendedName);
            }
            return targetFile;
        }
        return null;
    }
}

